/* 
    Novo projeto PMED_Calibra
    Criado para: 
    - Auxiliar no processo de calibração dos valores de offset e ganho das tomadas
    - Faciliar os testes da leitura de RFID nas tomadas
    - Alterado para usar captura sem DMA
    
*/
#include <stdio.h>

#include "mbed.h"
#include "rtos.h"
#include "cmsis_os.h"
#include "EthernetInterface.h"
#include "Settings.h"
#include "Capture.h"
#include "SignalProcessor.h"

extern "C" void mbed_reset();

EthernetInterface eth;

void InitializeEthernetLink();
int SelectOption();
int SelectOutlet();
void ShowRMSValues();
void ShowMeanValues();
void ShowSamplesFromChannel();
int SelectChannel();
void SetOffset();
void SetGain();
void TestRFID();
void TestManyTimesRFID();

void thread1(void const *args)
{
    DigitalOut led1(LED1);
    int op = 0;        
      
    Capture::InitializeAD();
      
    while(1)
    {   
        op = SelectOption();
        
        switch (op) {
            case (1): ShowRMSValues();          break;
            case (2): ShowMeanValues();         break;
            case (3): ShowSamplesFromChannel(); break;
            case (4): SetOffset();              break;
            case (5): SetGain();                break;
            case (6): TestRFID();               break;
            case (7): TestManyTimesRFID();      break;
            case (8): mbed_reset();             break;            
        }
    }
}

int main() {
    FILE *f;
    
    Settings::ReadFile();    
    //printf("Passou Settings, carregou arquivo\n");
    //Settings::ShowValues();
    
    InitializeEthernetLink();
    printf("\nIP Address is NEW %s\n", eth.getIPAddress());    
       
    /*
    unsigned short vet[256] = {2105,2105,2113,2127,2127,2125,2112,2113,2130,2130,2123,2112,2112,2128,2128,2123,2112,2113,2136,2136,2374,2551,2671,2869,2887,3036,2964,2964,2964,3145,3145,3206,3209,3298,3298,3264,3261,3208,3239,3239,3197,3197,3113,3032,3065,3065,3000,2901,2943,2943,2900,2852,2844,2863,2863,2838,2764,2791,2724,2724,2668,2710,2636,2658,2658,2606,2527,2443,2434,2434,2258,2066,2061,2080,2080,2063,2055,2055,2070,2070,2064,2051,2054,2069,2069,2062,2054,2058,2066,2309,2062,2052,2054,2067,2067,2063,2051,2049,2068,2068,2060,2053,2050,2067,2066,2069,2051,2053,2070,2070,2064,2050,2053,2070,2070,2062,2052,2055,2068,2068,2065,2052,2057,2072,2072,2064,2054,2054,2072,2072,2064,2053,2052,2069,2069,2064,2052,2053,2064,2064,2062,2049,2051,2067,2067,2059,2051,2050,2068,2068,2058,2046,2050,2068,2068,2061,2052,2058,2068,2068,2059,2052,2053,2067,2067,1744,1526,1471,1289,1289,1137,1142,1055,1120,1120,997,967,894,941,941,928,887,1001,949,949,1028,1105,1079,1191,1191,1223,1211,1223,1267,1267,1325,1267,1356,1327,1327,1369,1439,1381,1498,1498,1503,1503,1527,1545,1545,1635,1650,1778,1792,1792,1971,2108,2109,2126,2126,2124,2117,2118,2131,2131,2126,2118,2118,2138,2138,2134,2124,2114,2135,2135,2129,2121,2120,2136,2136,2128,2122,2122,2143,2120,2130,2120,2121,2139,2139,2130,2119,2121,2136,2136,2129};
    float sen[12],cos[12],vm;
    SignalProcessor::CalculateFFT(vet,sen,cos,&vm,1);
    
    printf("VM = %f\n",vm);
    for(int i=0;i<12;i++)
    {
        printf("SEN%d = %f, COS%d = %f\n",i,sen[i],i,cos[i]);
    }
    */    
    //Jump to the capture routine(will run on this thread)  
    thread1(NULL);
   
    while(1){//never reaches here  
        printf("Reset\n");
        f = fopen(FILENAMERESET, "a");
        if (f == NULL)            
            f = fopen(FILENAMERESET, "w");
        fprintf(f, "Laco Errado\n");
        fclose(f);
        Thread::yield();
    }
}
void TestManyTimesRFID(){
    char rfid_number[9], reads[100][9];
    int vezes[100];    
    bool achou;    
    int num_tom = 0, difs, i, j;
    
    num_tom = SelectOutlet();
    difs = 0;
    for(i=0; i < 10; i++){
        vezes[i] = 0;
        strcpy(reads[i], "VVVVVVVV"); // 'V' isn't valid digit (Hex)
    }
    for(i =0; i < 100; i++){
        Capture::ReadRFID(num_tom,rfid_number);
        //printf("\n{%s} - difs %d", rfid_number, difs);
        achou = false;
        for(j=0; j < difs; j++){
            if (strcmp(rfid_number, reads[j]) == 0){
                vezes[j] = vezes[j] + 1;
                achou = true;
            }
        }
        if (! achou){
            strcpy(reads[j], rfid_number);
            vezes[j] = 1;
            difs++;
        }
    }    
    
    for(i=0; i < difs; i++)
        printf("\nRFID {%s} read %d times.", reads[i], vezes[i]);    
}


void TestRFID(){
    char rfid_number[9], read[9];
    bool first = true;
    char c='%';
    float perc;
    int num_tom = 0, zero, ok, i;
    
    num_tom = SelectOutlet();
    
    zero = ok = 0;
    for(i =0; i < 5; i++){
        Capture::ReadRFID(num_tom,rfid_number);
        if (strcmp(rfid_number, "00000000") == 0)
            zero++;
        else{
            if (first){
                ok++;
                strcpy(read, rfid_number);
                first = false;
            }
            else
                if (strcmp(rfid_number, read) == 0)
                    ok++;            
        }
        if (ok == 3)
            break;
    }
    i = i == 5 ? 5 : i+1;
    
    if(ok == 3)
        perc = (float) ok/i;        
    else{
        perc = (float) zero/i ;        
        
        strcpy(read, "00000000");
    }
    perc = perc * 100 ; 
    printf("\nRFID SERIAL NUMBER: {%8s} with %.2f%c of hit.\n", read, perc, c);
}

void SetGain(){
    float rms[NUMBER_OF_CHANNELS], mv2[NUMBER_OF_CHANNELS];
    int under[NUMBER_OF_CHANNELS], over[NUMBER_OF_CHANNELS];
    float corrente = 0;
    int num_canal = 0;
    float soma_rms = 0;
    unsigned int cont = 0;
    float ganho = 0;
    
    printf("\n\nGain Adjustment:\n");
    printf("\nFor Adjust the gain, ALL gains in config file (PMED.TXT) MUST be 1 (one)");                   
    num_canal = SelectChannel();
    if (Settings::get_Gain(num_canal) != 1){
        printf("\n\nIt is impossibile to continue.\n");
        printf("\nThe gain in channel %d is %f and MUST be be equal to 1 (one).", num_canal, Settings::get_Gain(num_canal));
        printf("\nPut in the config file (PMED.TXT)\n\ngain%d=1\n", num_canal);
        printf("\nAfter save the config file, you MUST restart the mbed.");
        return;
    }
    
    printf("\nConnect the plug with the current used to adjustment (%s)", num_canal%2==0?"Phase":"Leakage");
    printf("\nSwitch on the charge and with an ammeter verify the current (RMS) consumed.");    
    printf("\nType the current in ammeter (%s): ", num_canal%2==0?"A":"mA");
    scanf("%f", &corrente);
    
    printf("\nWait aproximatelly 0.5s\n");
    
    while(cont<30)
    {
        //get sample values from 6 channels
        Capture::AcquireValues();
        
        SignalProcessor::CalculateRMSBulk(rms, mv2, under, over);
        soma_rms += rms[num_canal];
        cont++;
    }
    soma_rms /= 30;
    ganho = soma_rms/corrente;
    printf("\nPut in the configuration file (PMED.TXT)\ngain%d=%.4f\n\n",num_canal,ganho);
    printf("\nRepeat this procedure for the others channels and at the end, reset the Mbed.\n");
}

void SetOffset(){
    unsigned char tecla=0;
    unsigned int soma[6]={0,0,0,0,0,0};
    int cont = 0;
    float rms[NUMBER_OF_CHANNELS], mv2[NUMBER_OF_CHANNELS];
    int under[NUMBER_OF_CHANNELS], over[NUMBER_OF_CHANNELS];
    
    printf("\n\nAdjustment of Offset\n");
    printf("\nSwitch off all plugs from outlets.");
    printf("\nKeep the Protegemed on.\n");
    printf("\nType any key and press <ENTER> when ready!\n");
    scanf("%c", &tecla);
    
    printf("Wait aproximatelly 0.5s\n");
            
    while(cont<30)
    {
        //get sample values from 6 channels
        Capture::AcquireValues();
        
        SignalProcessor::CalculateRMSBulk(rms, mv2, under, over);
        for (int i=0; i<6;i++)
        {
            soma[i] += mv2[i];
        }
        cont++;
    }
    for (int i=0; i<6 ; i++) 
    {
        soma[i] = soma[i]/30;
    }
    printf("\n\nPut in file PMED.TXT an save it:\n");
    for (int i=0; i<6 ; i++) 
    {
        printf("offset%d=%u\n", i, soma[i]);
    }
    
    printf("\n\nReset the Mbed.\n");
    printf("\n\nYou MUST in the sequence adjust the gain!!!\n\n");
}

int SelectOutlet(){
    int num = 0;
    while(1){    
        printf("\nSelect an outlet to test (1 to 3): ");
        scanf("%d", &num);
        if ( (num > 3) || (num < 1) )
            printf("\n\n\nInvalid Outlet! - Retype a valid outlet\n\n\n ");        
        else
            break;
    }
    return num;
}

int SelectChannel(){
    int num_channel = 0;
    while(1){    
        printf("\n\nOdd channels are leakage and even channels are phase!!");
        printf("\nSelect a channel to visualize samples(0 to 5): ");
        scanf("%d", &num_channel);
        if ( (num_channel > 5) || (num_channel < 0) )
            printf("\n\n\nInvalid Channel! - Retype a valid channel\n\n\n ");        
        else
            break;
    }
    return num_channel;
}


void ShowSamplesFromChannel(){
    float samples[NUMBER_OF_SAMPLES];
    int cont = 0;
    int num_channel = SelectChannel();
    
    
    printf("\nValues of %d samples from channel %d.\n\n", NUMBER_OF_SAMPLES, num_channel );
            
    while(cont < 5)
    {
        //get sample values from 6 channels
        Capture::AcquireValues();
        
        Capture::CopyBuffer(num_channel, samples);
        printf("\n******* %da. sequence of samples (%s)\n\n", cont+1, num_channel%2==0?"Phase":"Leakage");
        for (int k=0; k< NUMBER_OF_SAMPLES; k++)
        {
            printf("%.0f ", samples[k]);
        }
        printf("\n");
        cont++;
    }
}

int SelectOption()
{
    int option;
    char s1[100];
    
    while (true)
    {   
        printf("\n\n");
        printf("+-------------------------------------+\n");
        printf("| PMED_Calibra: MENU    Oi              |\n");
        printf("| 1. RMS Values.                      |\n");
        printf("| 2. Mean Values.                     |\n");
        printf("| 3. Read samples from 1 channel.     |\n");
        printf("| 4. Offset adjust.                   |\n");
        printf("| 5. Gain adjust.                     |\n");
        printf("| 6. Read RFID tag.                   |\n");
        printf("| 7. Test RFID Read (many times).     |\n");
        printf("| 8. Reset the Mbed                   |\n");
        printf("+-------------------------------------+\n");
        printf("Select an Option: ");
        
        scanf("%d", &option);
        //fgets(s1, 10, stdin);
        //printf("Lido %s\n", s1);
        //option = s1[0] - '0';
        
        //printf("Opção %d\n", option);

        if ( (option > 8) || (option < 1) ){            
            printf("\n\n\nInvalid Option! - Retype a valid option\n\n\n ");
        }
        else
            break;
    }
    
    return option;
}


void ShowMeanValues(){    
    float rms[NUMBER_OF_CHANNELS], avg[NUMBER_OF_CHANNELS], mv2[NUMBER_OF_CHANNELS];
    int under[NUMBER_OF_CHANNELS], over[NUMBER_OF_CHANNELS];
    
    int cont = 0;
    avg[0] = avg[1] = avg[2] = avg[3] = avg[4] = avg[5] = 0;
    printf("\n\n------------------------------Mean VALUES-------------------------------");
    printf("\nCHANNEL\t0\t1\t\t2\t3\t\t4\t5");
    printf("\n\tPhase1\tLeakage1\tPhase2\tLeakage2\tPhase3\tLeakage3");
    printf("\n------------------------------------------------------------------------");
    while (cont < 10)
    {
        //get sample values from 6 channels
        Capture::AcquireValues();
        
        SignalProcessor::CalculateRMSBulk(rms, mv2, under, over);
        printf("\n%2d\t%.2f\t%.2f\t\t%.2f\t%.2f\t\t%.2f\t%.2f", cont+1,mv2[0],mv2[1],mv2[2],mv2[3],mv2[4],mv2[5]);
        avg[0] += mv2[0];
        avg[1] += mv2[1];
        avg[2] += mv2[2];
        avg[3] += mv2[3];
        avg[4] += mv2[4];
        avg[5] += mv2[5];
        cont++;
    }
    printf("\n------------------------------------------------------------------------");
    printf("\nAvg:\t%.2f\t%.2f\t\t%.2f\t%.2f\t\t%.2f\t%.2f",avg[0]/cont,avg[1]/cont,avg[2]/cont,avg[3]/cont,avg[4]/cont,avg[5]/cont);
    printf("\n------------------------------------------------------------------------\n\n");
}

void ShowRMSValues(){
    float rms[NUMBER_OF_CHANNELS], avg[NUMBER_OF_CHANNELS], mv2[NUMBER_OF_CHANNELS];
    int under[NUMBER_OF_CHANNELS], over[NUMBER_OF_CHANNELS];
    
    int cont = 0;
    avg[0] = avg[1] = avg[2] = avg[3] = avg[4] = avg[5] = 0;
    printf("\n\n-------------------------------RMS VALUES-------------------------------");
    printf("\nCHANNEL\t0\t1\t\t2\t3\t\t4\t5");
    printf("\n\tPhase1\tLeakage1\tPhase2\tLeakage2\tPhase3\tLeakage3");
    printf("\n------------------------------------------------------------------------");
    while (cont < 10)
    {
        //get sample values from 6 channels
        Capture::AcquireValues();                
        
        SignalProcessor::CalculateRMSBulk(rms, mv2, under, over);
        printf("\n%2d\t%.2f\t%.2f\t\t%.2f\t%.2f\t\t%.2f\t%.2f", cont+1,rms[0],rms[1],rms[2],rms[3],rms[4],rms[5]);
        avg[0] += rms[0];
        avg[1] += rms[1];
        avg[2] += rms[2];
        avg[3] += rms[3];
        avg[4] += rms[4];
        avg[5] += rms[5];
        cont++;
    }
    printf("\n------------------------------------------------------------------------");
    printf("\nAvg:\t%.2f\t%.2f\t\t%.2f\t%.2f\t\t%.2f\t%.2f",avg[0]/cont,avg[1]/cont,avg[2]/cont,avg[3]/cont,avg[4]/cont,avg[5]/cont);
    printf("\n------------------------------------------------------------------------\n\n");
}

void InitializeEthernetLink()
{
    if(Settings::get_Dhcp())
        //EthernetIf::Initialize(); //Use DHCP
        eth.init(); //Use DHCP
    else
        //EthernetIf::Initialize(Settings::get_IpAddress(),Settings::get_Netmask(),Settings::get_Gateway());
        eth.init(Settings::get_IpAddress(),Settings::get_Netmask(),Settings::get_Gateway());
        
    //EthernetIf::Connect();
    eth.connect();
    //printf("IP Address is %s\n", EthernetIf::get_IpAddress());
}
