/*
 * capture.h
 *
 *  Created on: 
 *      Author: 
 */

#ifndef CAPTURE_H
#define CAPTURE_H

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "mbed.h"
#include "rtos.h"
#include "dma.h"
#include "adc.h"

#include "Settings.h"

class Capture
{
    
protected:
    static bool flag_capture;
    static int cnt_buffer;
    static int channel_number;  
    static int cnt_interrupt;         
    
public:
    //Usa buffe r de 256 * 2 valores para usar na FFT
    static float m_AdcBuffers[NUMBER_OF_CHANNELS][NUMBER_OF_SAMPLES];
    
public:

    static float GetValue(int nsamples, int nchannel);        
    static void  PutValue(int nsamples, int nchannel, float value);
    static void  CopyBuffer(int channel, float *dest);

    static void AcquireValues();
    static void InitializeAD();
    static void FcnTimerInt(void);    
    
    static void ReadRFID(int channel,char *rfid);

};

#endif