/*
 * adc.c
 *
 *  Created on: 02/07/2011
 *      Author: francisco
 */

#include <LPC17xx.h>
#include "adc.h"

void init_adc(int adc_clk)
{
    // Turn on power to ADC block
    LPC_SC->PCONP |=  PCADC;

    // Turn on ADC peripheral clock
        LPC_SC->PCLKSEL0 &= ~(3 << PCLK_ADC);
        LPC_SC->PCLKSEL0 |=  (ADC_CCLK << PCLK_ADC);    //CLK/8

        unsigned int clkdiv = (SystemCoreClock/1)/65;
        clkdiv = clkdiv/adc_clk;

        LPC_ADC->ADCR &= ~(ADC_OPERATIONAL|ADC_CLKDIV(255));
        LPC_ADC->ADCR |= (ADC_OPERATIONAL|ADC_CLKDIV(clkdiv));

    //NVIC_EnableIRQ(ADC_IRQn);
}

void setup_start(int mode,int edge)
{
    LPC_ADC->ADCR |= mode;
}

void select_channels(int adc_ch)
{
    LPC_ADC->ADCR &= ~(ADC_CH_0|ADC_CH_1|ADC_CH_2|ADC_CH_3|ADC_CH_4|ADC_CH_5|ADC_CH_6|ADC_CH_7);
    LPC_ADC->ADCR |= adc_ch;

    LPC_ADC->ADINTEN |= (1U<<8);//adc_ch;

    if(adc_ch&ADC_CH_0)
    {
        LPC_PINCON->PINSEL1 |= 1U<<14;
        LPC_PINCON->PINMODE1 |= 2U<<14;
    }
    if(adc_ch&ADC_CH_1)
    {
        LPC_PINCON->PINSEL1 |= 1U<<16;
        LPC_PINCON->PINMODE1 |= 2U<<16;
    }
    if(adc_ch&ADC_CH_2)
    {
        LPC_PINCON->PINSEL1 |= 1U<<18;
        LPC_PINCON->PINMODE1 |= 2U<<18;
    }
    if(adc_ch&ADC_CH_3)
    {
        LPC_PINCON->PINSEL1 |= 1U<<20;
        LPC_PINCON->PINMODE1 |= 2U<<20;
    }
    if(adc_ch&ADC_CH_4)
    {
        LPC_PINCON->PINSEL3 |= 3U<<28;
        LPC_PINCON->PINMODE3 |= 2U<<28;
    }
    if(adc_ch&ADC_CH_5)
    {
        LPC_PINCON->PINSEL3 |= 3U<<30;
        LPC_PINCON->PINMODE3 |= 2U<<30;
    }
    if(adc_ch&ADC_CH_6)
    {
        LPC_PINCON->PINSEL0 |= 2U<<6;
        LPC_PINCON->PINMODE0 |= 2U<<6;
    }
    if(adc_ch&ADC_CH_7)
    {
        LPC_PINCON->PINSEL0 |= 2U<<4;
        LPC_PINCON->PINMODE0 |= 2U<<4;
    }
}
