/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "stdio.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS 500
#define SW2 P0_4
// #define alsOut P10_0

//Global variables
char buffer[80];
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    DigitalIn pushButton(SW2, PullUp);
    DigitalOut thermVcc(P10_3);
    DigitalOut thermGnd(P10_0);
    AnalogIn thermVal(P10_1);
    AnalogIn lightLevel(P10_4);
    
    /* Data Structures */
    
    struct dataSet {
        float highTempThresh = 26;
        float lowTempThresh = 23;
        float ambientTemp;
        float highLightThresh = 80;
        float lowLightThresh = 20;
        float ambientLight;
        } myData;
    
/* prototype of function */
void displayAt( int y, int x, char *buffer );
void initialise();
void readSensors();
void displayData();

int main()
{
   initialise(); // function to setup VT100 display

/******************************************************************************************
*
* Main loop:=
*
* flash status led
* read sensors
* display data read from the sensors and threshold values
* sleep for 0.5seconds
*
*******************************************************************************************/

    while (true) {
        led=!led; // flashing status signal
        readSensors();
        displayData();
        thread_sleep_for(BLINKING_RATE_MS);
        }
}
void readSensors() {
/*read thermistor Voltage*/ 
            float refVoltage = thermVal.read() * 2.4;// Range of ADC 0->2*Vref
            float refCurrent = refVoltage / 10000.0; //10k Reference Resistor
            float therVoltage = 3.3 - refVoltage; // Assume supply voltage is 3.3v
            float thermResistance = therVoltage / refCurrent;
            float logrT = (float32_t)log((float64_t)thermResistance);
            
            /*Calculate temperature from the resistance of thermistor using Steinhart-Hart Equation*/
            float stEqn = (float32_t) ((0.0009032679) + ((0.000248772) * logrT) + ((2.041094E-07) * pow((float64)logrT, (float32)3)));
                                     
            myData.ambientTemp = (float32_t)(((1.0 / stEqn) - 273.15) + 0.5); 
            myData.ambientLight = lightLevel.read() * 100;     
}
void displayData() {  
            if (myData.ambientTemp >  myData.highTempThresh) printf("\033[31m");  //Red Text 
            else if (myData.ambientTemp >  myData.lowTempThresh) printf("\033[34m");  //Blue Text 
            else printf("\033[32m"); // Green Text          
            sprintf(buffer, "Temerpature is %2.1f C", myData.ambientTemp);
            displayAt (1, 3, buffer);
                        sprintf(buffer, "Low Threshold is %2.1f C", myData.lowTempThresh);
            printf("\033[37m"); // default text
            displayAt (27, 3, buffer);
                        sprintf(buffer, "High Threshold is %2.1f C", myData.highTempThresh);
            displayAt (55, 3, buffer);
            
            sprintf( buffer, "Ambient Light is: %3.1f%c", myData.ambientLight, 0x25 );
            displayAt(1,4, buffer);
    }
void displayAt( int y, int x, char *buffer ) {
    printf("\033[%d;%dH%s", y, x, buffer);
    fflush(stdout);
    }
    
void initialise() {
   printf("\033[2J\033[H"); // clear screen and move the cursor to 0, 0
   printf("\033[?25l"); // Turn off visable cursor
   fflush(stdout); // send the codes to the terminal
   printf("Environmental Control System");
   // printf( "|033[34m" );
   }