#include "mbed.h"
#include "SENSOR.h"

#include "HTTPClient.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "Websocket.h"
//#include "NTPClient.h"

#define SENSOR_ARRAY_SIZE 6

SENSOR *sensor_array[SENSOR_ARRAY_SIZE];
Serial pc(USBTX, USBRX); // tx, rx
ESP8266Interface wifi(PA_11,PA_12,PB_12,"EE-mehrg7","MFPHOME0708",115200); // TX,RX,Reset,SSID,Password,Baud
//NTPClient ntp;


int main() {
    pc.baud(921600);

#if defined(TARGET_NUCLEO_F401RE)
    SPI spi(PB_15, PB_14, PB_13); // mosi, miso, sclk
    EthernetInterface eth(&spi, PB_1, PB_2); // spi, cs, reset
    #warning "setup for F401RE"
#endif

    //Create sensors
//    pc.printf("Creating sensor 0\n\r");
    sensor_array[0] = new SENSOR( PB_9, PB_8,  NC, NC, PA_0, PA_9);  //I2C1,A0
//    pc.printf("Creating sensor 1\n\r");
    sensor_array[1] = new SENSOR( PB_3, PB_10, NC, NC, PA_1, PC_7); //I2C2,A1
//    pc.printf("Creating sensor 2\n\r");
    sensor_array[2] = new SENSOR( PB_4, PA_8, NC, NC, PA_4, PB_6);  //I2C3,A2
//    pc.printf("Creating sensor 3\n\r");
    sensor_array[3] = new SENSOR( PA_3, NC, NC, NC, PB_0, PA_7);    //GPIO,A3
//    pc.printf("Creating sensor 4\n\r");
    sensor_array[4] = new SENSOR( PA_2, NC, NC, NC, PC_1, PA_6);    //GPIO,A4
//    pc.printf("Creating sensor 5\n\r");
    sensor_array[5] = new SENSOR( PA_10, NC, NC, NC, PC_0, PA_5);   //GPIO,A5

    //Statically connect sensors
//    pc.printf("Connecting sensor 0\n\r");
//    sensor_array[0]->detectSensor(BH1750_SENSOR);
    sensor_array[0]->detectSensor(NO_SENSOR);
//    pc.printf("Connecting sensor 1\n\r");
    sensor_array[1]->detectSensor(NO_SENSOR);
//    sensor_array[1]->detectSensor(NO_SENSOR);
//    pc.printf("Connecting sensor 2\n\r");
    sensor_array[2]->detectSensor(NO_SENSOR);
//    sensor_array[2]->detectSensor(NO_SENSOR);
//    pc.printf("Connecting sensor 3\n\r");
//    sensor_array[3]->detectSensor(MQ135_SENSOR);
    sensor_array[3]->detectSensor(NO_SENSOR);
//    pc.printf("Connecting sensor 4\n\r");
    sensor_array[4]->detectSensor(NO_SENSOR);
//    sensor_array[4]->detectSensor(ML8511_SENSOR);
//    pc.printf("Connecting sensor 5\n\r");
//    sensor_array[5]->detectSensor(DHT11_SENSOR);
    sensor_array[5]->detectSensor(NO_SENSOR);

    string sensor_reading;
    string sensor_logentry;
    sensorStatus sensor_status;
    sensorType sensor_type;
        
    pc.printf("pre init eth\r\n", eth.getMACAddress());
    eth.init("192.168.1.202", "255.255.255.0", "192.168.1.254"); //Use DHCP
    pc.printf("Initialized, MAC: %s\r\n", eth.getMACAddress());
    eth.connect();
    pc.printf("Connected, IP: %s, MASK: %s, GW: %s\r\n",eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());

/*
    if (ntp.setTime("0.uk.pool.ntp.org") == 0)
    {
        time_t ctTime;
        ctTime = time(NULL);
        printf("Time is set to : %s \r\n", ctime(&ctTime));
    }
    else
    {
        printf("Error getting time \r\n");
    }
    wait(2);
*/    
    
    pc.printf("trying to connect to ws://192.168.1.84:8000/\n\r");
    Websocket ws("ws://192.168.1.84:8000/");

    if(!ws.connect()) {
        pc.printf("Failed to connect to ws://192.168.1.84:8000/\n\r");
    } else {
        pc.printf("Starting reading sensor array\n\r");

        while(1) {
            for(int sensor_index = 0; sensor_index < SENSOR_ARRAY_SIZE; sensor_index++) {
                pc.printf("Reading sensor %d\n\r", sensor_index);
                sensor_type = sensor_array[sensor_index]->getSensorType();
                pc.printf("Sensor type:   %d\n\r", sensor_type);
                sensor_status = sensor_array[sensor_index]->readSensor(sensor_reading);
                pc.printf("Sensor status: %d\n\r", sensor_status);
                switch (sensor_status) {
                    case SENSOR_SUCCESS:
                        pc.printf("Reading sensor(%d) of type(%d), status(%d): %s\n\r", sensor_index, (int)sensor_type, (int)sensor_status, sensor_reading.c_str());
                        break;
                    case SENSOR_UNCONNECTED:
                        break;
                    default:
                        pc.printf("Problem reading (%d) of type(%d), status(%d): %s\n\r", sensor_index, (int)sensor_type, (int)sensor_status, sensor_reading.c_str());
                        break;
                        break;
                }
            }
            pc.printf("send: %s\n\r", sensor_reading.c_str());
            char msg[1000];
            strcpy(msg, sensor_reading.c_str());
            ws.send(msg);    
            pc.printf("\n\r\n\r");
            wait(1);
        }
    }

    
    ws.close();
    
    while(true) {}

}
