#ifndef MBED_sensorTypes_H
#define MBED_sensorTypes_H


enum sensorIOType{
    NONE      = 0,
    I2CIO     = 11,
    SERIALIO  = 12,
    ONEWIREIO   = 13,
    ANALOGIO  = 14
};

enum sensorStatus {
    SENSOR_READING_ERROR = 0,
    SENSOR_DETECTION_ERROR = 1,
    SENSOR_SUCCESS = 2,
    SENSOR_PARAM_OUT_RANGE = 3,
    SENSOR_CONNECTED = 10,
    SENSOR_UNCONNECTED = 11,
    SENSOR_TYPE_UNSUPPORTED = 12
};

enum sensorType {
    NO_SENSOR = 01,
    UNSUPPORTED_SENSOR = 02,
    DS1820_SENSOR = 10,
    DHT11_SENSOR = 11,
    DHT22_SENSOR = 12,
    ML8511_SENSOR = 20,
    BH1750_SENSOR = 21,
    MQ135_SENSOR = 30
};


enum sensorReadingType {
    //DHT=01 Reading types
    DHT_FIRST = 0x01003,
    DHT_TEMP  = 0x01001,
    DHT_HUMID = 0x01002,
    DHT_ALL   = 0x01FFF,
    //ML8511=02 Reading types
    ML8511_FIRST = 0x02002,
    ML8511_UV    = 0x02001,
    ML8511_ALL   = 0x02FFF,
    //BH1750=03 Reading types
    BH1750_FIRST = 0x03002,
    BH1750_VL    = 0x03001,
    BH1750_ALL   = 0x03FFF,
    //MQ135=04 Reading types
    MQ135_FIRST = 0x04003,
    MQ135_CO2    = 0x04001,
    MQ135_NH3    = 0x04002,
    MQ135_ALL    = 0x04FFF,
    //BH1750=03 Reading types
    DS1820_FIRST = 0x05002,
    DS1820_TEMP  = 0x05001,
    DS1820_ALL   = 0x05FFF,
};

#endif