#ifndef MBED_SENSOR_H
#define MBED_SENSOR_H

#include "mbed.h"
#include <string> 
#include "SupportedDevices.h"
#include "sensorTypes.h"
#include "DHTSensor.h"
#include "BH1750Sensor.h"
#include "DS1820Sensor.h"
#include "MQ135Sensor.h"
#include "ML8511Sensor.h"



class SENSOR {

public:
    SENSOR (
        PinName io_pin_name1, 
        PinName io_pin_name2, 
        PinName io_pin_name3, 
        PinName io_pin_name4,
        PinName io_pin_name5, 
        PinName sense_pin_name1
    );
    ~SENSOR();

    sensorType    detectSensor();
    sensorType    getSensorType();
    sensorStatus  getSensorStatus();
    sensorType    detectSensor(sensorType stype);    
    sensorStatus readSensor(string &sensor_reading);
    
        
private:
    sensorType detectSensorType();
    PinName io_pname1;
    PinName io_pname2;
    PinName io_pname3;
    PinName io_pname4;
    PinName io_pname5;
    PinName sense_pname1;
    sensorIOType io_type;
    sensorType sensor_type;
    sensorStatus sensor_status;
    DigitalInOut sense_pin1;
    DS1820Sensor *ds1820_sensor_ptr;
    DHTSensor *dht11_sensor_ptr;
    DHTSensor *dht22_sensor_ptr;
    MQ135Sensor *mq135_sensor_ptr;
    ML8511Sensor *ml8511_sensor_ptr;
    BH1750Sensor *bh1750_sensor_ptr;
};

#endif
