#include "MQ135Sensor.h"

MQ135Sensor::MQ135Sensor(PinName analog_out_pin_name): MQ135_sensor(analog_out_pin_name) {
    analog_out_pname = analog_out_pin_name;
    reading_type = MQ135_ALL;
}

        
sensorStatus MQ135Sensor::readSensor(string &sensor_reading) {

    //add start to reading
    sensor_reading = "{";
    
    //Read Temp
    if ((reading_type & MQ135_CO2) == MQ135_CO2) {
        float co2 = MQ135_sensor.getResistance();
        //check required here

        char reading_type_string[10];
        sprintf(reading_type_string, "%05X", MQ135_CO2);        
        char co2_string[10];
        sprintf(co2_string, "%2.2f", co2);        
        sensor_reading = sensor_reading + reading_type_string + ":" + co2_string;
    }
    
    if ((reading_type & MQ135_NH3) == MQ135_NH3) {
        float nh3 = MQ135_sensor.getResistance();
        //check required here
        char reading_type_string[10];
        sprintf(reading_type_string, "%05X", MQ135_NH3);        
        char nh3_string[10];
        sprintf(nh3_string, "%2.2f", nh3);        
        sensor_reading = sensor_reading + ", " + reading_type_string + ":" + nh3_string;
    }

    //add end to reading
    sensor_reading = sensor_reading + "}";
    
    return SENSOR_SUCCESS;
}

    
sensorStatus MQ135Sensor::setReadingType(sensorReadingType sensor_reading_types) {
    if ((sensor_reading_types > MQ135_FIRST) && (sensor_reading_types <= MQ135_ALL)) {
        reading_type = sensor_reading_types;
        return SENSOR_SUCCESS;
    } else {
        return SENSOR_PARAM_OUT_RANGE;
    }
}  
    
sensorReadingType MQ135Sensor::getReadingType() {
    return reading_type;
}

