#include "ML8511Sensor.h"

ML8511Sensor::ML8511Sensor(PinName analog_in_pin_name): ML8511_sensor(analog_in_pin_name) {
    reading_type = ML8511_ALL;
    analog_in_pname = analog_in_pin_name;
}

        
sensorStatus ML8511Sensor::readSensor(string &sensor_reading) {

    //add start to reading
    sensor_reading = "{";
    
    //Read 
    if ((reading_type & ML8511_UV) == ML8511_UV) {
        // UV index
        // 1V=0
        // 2V=10
        float uv = (ML8511_sensor.read()*3.3-1.0)/(2.0-1.0)*10.0;
        //check required here

        char reading_type_string[10];
        sprintf(reading_type_string, "%05X", ML8511_UV);        
        char uv_string[10];
        sprintf(uv_string, "%2.2f", uv);        
        sensor_reading = sensor_reading + reading_type_string + ":" + uv_string;
    }
    
    //add end to reading
    sensor_reading = sensor_reading + "}";
    
    return SENSOR_SUCCESS;
}

    
sensorStatus ML8511Sensor::setReadingType(sensorReadingType sensor_reading_types) {
    if ((sensor_reading_types > ML8511_FIRST) && (sensor_reading_types <= ML8511_ALL)) {
        reading_type = sensor_reading_types;
        return SENSOR_SUCCESS;
    } else {
        return SENSOR_PARAM_OUT_RANGE;
    }
}  
    
sensorReadingType ML8511Sensor::getReadingType() {
    return reading_type;
}

