#include "DS1820Sensor.h"

DS1820Sensor::DS1820Sensor(PinName one_wire_pinname): DS1820_sensor(one_wire_pinname) {
    reading_type = DS1820_ALL;
}

        
sensorStatus DS1820Sensor::readSensor(string &sensor_reading) {

    //add start to reading
    sensor_reading = "{";
    
    //Read Temp
    if ((reading_type & DS1820_TEMP) == DS1820_TEMP) {
        float temp = DS1820_sensor.read();
        //check required here

        char reading_type_string[10];
        sprintf(reading_type_string, "%05X", DS1820_TEMP);        
        char temp_string[10];
        sprintf(temp_string, "%2.2f", temp);        
        sensor_reading = sensor_reading + reading_type_string + ":" + temp_string;
    }
    
    //add end to reading
    sensor_reading = sensor_reading + "}";
    
    return SENSOR_SUCCESS;
}

    
sensorStatus DS1820Sensor::setReadingType(sensorReadingType sensor_reading_types) {
    if ((sensor_reading_types > DS1820_FIRST) && (sensor_reading_types <= DS1820_ALL)) {
        reading_type = sensor_reading_types;
        return SENSOR_SUCCESS;
    } else {
        return SENSOR_PARAM_OUT_RANGE;
    }
}  
    
sensorReadingType DS1820Sensor::getReadingType() {
    return reading_type;
}

