#include "DHTSensor.h"

DHTSensor::DHTSensor(PinName pn, int dht_type): dht_sensor(pn, dht_type) {
    reading_type = DHT_ALL;
}

        
sensorStatus DHTSensor::readSensor(string &sensor_reading) {

    //add start to reading
    int err = dht_sensor.readData();
    //Read Temp
    if (err == 0) {
        sensor_reading = "{";
        if ((reading_type & DHT_TEMP) == DHT_TEMP) {
            float temp = dht_sensor.ReadTemperature(CELCIUS);
            //check required here
    
            char reading_type_string[10];
            sprintf(reading_type_string, "%05X", DHT_TEMP);        
            char temp_string[10];
            sprintf(temp_string, "%2.2f", temp);        
            sensor_reading = sensor_reading + reading_type_string + ":" + temp_string;
        }
        
        if ((reading_type & DHT_HUMID) == DHT_HUMID) {
            float humid = dht_sensor.ReadHumidity();
            //check required here
            char reading_type_string[10];
            sprintf(reading_type_string, "%05X", DHT_HUMID);        
            char humid_string[10];
            sprintf(humid_string, "%2.2f", humid);        
            sensor_reading = sensor_reading + ", " + reading_type_string + ":" + humid_string;
        }
        
        //add end to reading
        sensor_reading = sensor_reading + "}";
        return SENSOR_SUCCESS;
        
    } else {
        sensor_reading = sensor_reading + "";
        return SENSOR_READING_ERROR;
    }
    
}

    
sensorStatus DHTSensor::setReadingType(sensorReadingType sensor_reading_types) {
    if ((sensor_reading_types > DHT_FIRST) && (sensor_reading_types <= DHT_ALL)) {
        reading_type = sensor_reading_types;
        return SENSOR_SUCCESS;
    } else {
        return SENSOR_PARAM_OUT_RANGE;
    }
}  
    
sensorReadingType DHTSensor::getReadingType() {
    return reading_type;
}

