#include "SENSOR.h"


SENSOR::SENSOR (
    PinName io_pin_name1, 
    PinName io_pin_name2, 
    PinName io_pin_name3, 
    PinName io_pin_name4,
    PinName io_pin_name5, 
    PinName sense_pin_name1
): sense_pin1(sense_pin_name1) {
    io_type = NONE;
    io_pname1 = io_pin_name1;
    io_pname2 = io_pin_name2;
    io_pname3 = io_pin_name3;
    io_pname4 = io_pin_name4;
    io_pname5 = io_pin_name5;
    sense_pname1 = sense_pname1;
}


SENSOR::~SENSOR() {
    io_type = NONE;
    io_pname1 = NC;
    io_pname2 = NC;
    io_pname3 = NC;
    io_pname4 = NC;
    io_pname5 = NC;
    sense_pname1 = NC;
}


sensorType SENSOR::detectSensorType() {
    return NO_SENSOR;
}

sensorType SENSOR::getSensorType() {
    return sensor_type;
}

sensorStatus SENSOR::getSensorStatus() {
    return sensor_status;
}

sensorType SENSOR::detectSensor() {
    sensor_type = detectSensorType();
    sensor_type = detectSensor(sensor_type);
    return sensor_type;
}

sensorType SENSOR::detectSensor(sensorType stype) {

    //Set sensor_type
    sensor_type = stype;
    
    //handle detected sensor
    switch (stype) {
        case DS1820_SENSOR:
            ds1820_sensor_ptr = new DS1820Sensor(io_pname1);
            break;
        case DHT11_SENSOR:
            dht11_sensor_ptr = new DHTSensor(io_pname1, DHT11);            
            break;
        case DHT22_SENSOR:
            dht22_sensor_ptr = new DHTSensor(io_pname1, DHT22);            
            break;
        case ML8511_SENSOR:
            ml8511_sensor_ptr = new ML8511Sensor(io_pname5);            
            break;
        case MQ135_SENSOR:
            mq135_sensor_ptr = new MQ135Sensor(io_pname5);            
            break;
        case BH1750_SENSOR:
//            bh1750_sensor_ptr = new BH1750Sensor(io_pname1, io_pname2);            
            bh1750_sensor_ptr = new BH1750Sensor(io_pname1, io_pname2);            
            break;
        case UNSUPPORTED_SENSOR:
            sensor_status = SENSOR_DETECTION_ERROR;
            return(sensor_type);
            break;
        case NO_SENSOR:
            sensor_status = SENSOR_UNCONNECTED;
            return(sensor_type);
            break;
        default: 
//            printf("Error, should not get here!\r\n");
            break;
    }

    sensor_status = SENSOR_CONNECTED;           
    return sensor_type;
}

sensorStatus SENSOR::readSensor(string &sensor_reading) {
    sensorStatus status;
    switch (sensor_type) {
         case DS1820_SENSOR:
            status = ds1820_sensor_ptr->readSensor(sensor_reading);
            break;
        case DHT11_SENSOR:
            status = dht11_sensor_ptr->readSensor(sensor_reading);
            break;
        case DHT22_SENSOR:
            status = dht22_sensor_ptr->readSensor(sensor_reading);
            break;
        case ML8511_SENSOR:
            status = ml8511_sensor_ptr->readSensor(sensor_reading);
            break;
        case MQ135_SENSOR:
            status = mq135_sensor_ptr->readSensor(sensor_reading);
            break;
        case BH1750_SENSOR:
            status = bh1750_sensor_ptr->readSensor(sensor_reading);
            break;
        case UNSUPPORTED_SENSOR:
            sensor_status = SENSOR_TYPE_UNSUPPORTED; 
            sensor_reading = "";   
            return(sensor_status);
            break;
        case NO_SENSOR:
            sensor_status = SENSOR_UNCONNECTED;
            sensor_reading = "";   
            return(sensor_status);
            break;
        default: 
//            printf("Error, should not get here!\r\n");
            break;
    }

    return status;
}


