#include "BH1750Sensor.h"

BH1750Sensor::BH1750Sensor(PinName scaPin, PinName sclPin): BH1750_sensor(scaPin, sclPin) {
    reading_type = BH1750_ALL;
    BH1750_sensor.init();
}

        
sensorStatus BH1750Sensor::readSensor(string &sensor_reading) {

    //add start to reading
    sensor_reading = "{";
    
    //Read Visible Light Intensity
    if ((reading_type & BH1750_VL) == BH1750_VL) {
        float vl = BH1750_sensor.readIntensity();
        //check required here

        char reading_type_string[10];
        sprintf(reading_type_string, "%05X", BH1750_VL);        
        char vl_string[10];
        sprintf(vl_string, "%2.2f", vl);        
        sensor_reading = sensor_reading + reading_type_string + ":" + vl_string;
    }
    
    //add end to reading
    sensor_reading = sensor_reading + "}";
    
    return SENSOR_SUCCESS;
}

    
sensorStatus BH1750Sensor::setReadingType(sensorReadingType sensor_reading_types) {
    if ((sensor_reading_types > BH1750_FIRST) && (sensor_reading_types <= BH1750_ALL)) {
        reading_type = sensor_reading_types;
        return SENSOR_SUCCESS;
    } else {
        return SENSOR_PARAM_OUT_RANGE;
    }
}  
    
sensorReadingType BH1750Sensor::getReadingType() {
    return reading_type;
}

