#include "mbed.h"

#include "HTTPClient.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "Websocket.h"



DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx

//ESP8266Interface wifi(D8,D2,D7,"EE-mehrg7","MFPHOME0708",115200); // TX,RX,Reset,SSID,Password,Baud
ESP8266Interface wifi(PA_11,PA_12,PB_12,"EE-mehrg7","MFPHOME0708",115200); // TX,RX,Reset,SSID,Password,Baud
 
int main() {
   pc.baud(921600);
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
//    wait(2);
    printf("IP Address is %s\n\r", wifi.getIPAddress());
//    wait(2);
   
    printf("connect ws\n\r", wifi.getIPAddress());
    Websocket ws("ws://192.168.1.84:8000/");
//    wait(2);
    
    //Check for successful socket connection
    if(!ws.connect())
        ws.close();
    else{
        char str[100];
        
        for(int i=0; i<0x7fffffff; ++i) {
            // string with a message
            sprintf(str, "{\"ts\":1, \"readings\": [{\"reading\": \"d\", \"value\": %d}]}", i);
            printf("send: %s\n\r",str);
            ws.send(str);
        
            // clear the buffer and wait a sec...
            memset(str, 0, 100);
            wait(2);
        
            // websocket server should echo whatever we sent it
            if (ws.read(str)) {
                printf("rcv'd: %s\n", str);
            }
        }
    }
    ws.close();
    
    while(true) {}
}
 