#include "mbed.h"
#include "MaximInterface/Links/RomCommands.hpp"
#include "Platforms/mbed/TARGET_STM32/GpioOneWireMaster.hpp"
#include "MaximInterface/Devices/DS28EC20.hpp"

DigitalOut myled(LED1);
#define CONFIG_OW_PIN_NAME  PinName::PA_1

class Sleep : public MaximInterface::Sleep
{
public:
    virtual void invoke (int ms) const
    {
        uint32_t ticks = (ms * 1000u) / osKernelGetTickFreq();
        osDelay(ticks);
        return;
    }

    virtual ~Sleep(void)
    {
        return;
    };
};

static Sleep sleepObj;

class SelectOverdriveSkipRom
{
public:
    typedef MaximInterface::SelectRom::argument_type argument_type;
    typedef MaximInterface::SelectRom::result_type result_type;

    explicit SelectOverdriveSkipRom(MaximInterface::RomId::const_span romId)
    {
        setRomId(romId);
    }

    MaximInterface::RomId::const_span romId() const
    {
        return romId_;
    }

    void setRomId(MaximInterface::RomId::const_span romId)
    {
        MaximInterface::copy(romId, MaximInterface::make_span(romId_));
    }

    MaximInterface_EXPORT MaximInterface::error_code operator()(MaximInterface::OneWireMaster & master) const
    {
#if 0
        return MaximInterface::skipRom(master);
#else
        return MaximInterface::overdriveSkipRom(master);
#endif
    }

private:
    MaximInterface::RomId::array romId_;
};



int main()
{
    MaximInterface::GpioOneWireMaster *p_GPIO_OW_Master = new (std::nothrow) MaximInterface::GpioOneWireMaster(CONFIG_OW_PIN_NAME);
    MaximInterface::OneWireMaster &OW_Master(*p_GPIO_OW_Master);
    MaximInterface::error_code err = p_GPIO_OW_Master->initialize();

    MaximInterface::SearchRomState State;

    /* ... Fallback to standard speed after ID-chip has been powered off */
    OW_Master.setSpeed(MaximInterface::OneWireMaster::StandardSpeed);

    err = MaximInterface::searchRom(OW_Master, State);

    if (!err) {
        if (familyCode(State.romId) == MaximInterface::DS28EC20::familyCode) {
            /* ... wait for 50 ms */
            uint32_t Ticks = (50u * 1000u) / osKernelGetTickFreq();
            osDelay(Ticks);

            SelectOverdriveSkipRom RomSelectorObject(State.romId);

            MaximInterface::DS28EC20 *p_EEPROM = new (std::nothrow) MaximInterface::DS28EC20(sleepObj, OW_Master, MaximInterface::SelectRom(RomSelectorObject), RomSelectorObject.romId());

            if (NULL != p_EEPROM) {
                size_t Size = MaximInterface::DS28EC20::memoryPages * MaximInterface::DS28EC20::pageSizeBytes;
                MaximInterface::DS28EC20::Address Addr = static_cast<MaximInterface::DS28EC20::Address>(0);
                size_t ActualLength = 32u;
                uint8_t Buffer[32u] = {0};
                err = p_EEPROM->readMemoryExt(Addr, &Buffer[0], ActualLength);
                err = MaximInterface::writeMemory(*p_EEPROM, Addr, &Buffer[0], ActualLength);
            }
        }
    }


    while(1) {
        myled = 1;
        wait_us(2000);
        myled = 0;
        wait_us(2000);
    }
}
