#ifndef MaximInterface_GpioOneWireMaster
#define MaximInterface_GpioOneWireMaster

#include <MaximInterface/Links/OneWireMaster.hpp>
#include <DigitalOut.h>

namespace MaximInterface {

class GpioOneWireMaster : public OneWireMaster {
public:
  /// @param owGpio Pin to use for 1-Wire bus
  /// @param extSpu Pin to use for external Strong Pullup
  explicit GpioOneWireMaster(PinName owGpio, PinName extSpu = NC,
                             bool extSpuActiveHigh = false);

  error_code initialize();

  virtual error_code reset();
  virtual error_code touchBitSetLevel(bool & sendRecvBit, Level afterLevel);
  virtual error_code setSpeed(Speed newSpeed);
  virtual error_code setLevel(Level newLevel);

private:
  unsigned int port;
  unsigned int pin;
  Speed speed;
  mbed::DigitalOut extSpu;
  bool extSpuActiveHigh;

  inline void writeGpioLow();
  inline void writeGpioHigh();
  inline bool readGpio();
  inline void setGpioMode(unsigned int mode);
};

} // namespace MaximInterface

#endif
