/* Gatech ECE2035 2015 SPRING PAC MAN
 * Copyright (c) 2015 Gatech ECE2035
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
/** @file main.cpp */
// Include header files for platform
#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"

// Include header files for pacman project
#include "globals.h"
#include "map_public.h"
#include "pacman.h"
#include "ghost.h"
#include "MMA8452.h"
#include "doubly_linked_list.h"

// Platform initialization
DigitalIn left_pb(p21);  // push bottem
DigitalIn right_pb(p22); // push bottem
DigitalIn up_pb(p23);    // push bottem
DigitalIn down_pb(p24);  // push bottem
DigitalOut myled(LED1);  // LED
uLCD_4DGL uLCD(p9,p10,p11); // LCD (serial tx, serial rx, reset pin;)
Serial pc(USBTX,USBRX);     // used by Accelerometer
MMA8452 acc(p28, p27, 100000); // Accelerometer
AnalogOut DACout(p18);      // speaker
wave_player waver(&DACout); // wav player
SDFileSystem sd(p5, p6, p7, p8, "sd"); // SD card and filesystem (mosi, miso, sck, cs)

// Example of the decleration of your implementation
void playSound(char * wav);


/** Main() is where you start your implementation
    @brief The hints of implementation are in the comments. <br>
    @brief You are expected to implement your code in main.cpp and pacman.cpp. But you could modify any code if you want to make the game work better.
*/
int main()
{   
    // Initialize the timer
    /// [Example of time control implementation]
        /// Here is a rough example to implement the timer control <br><br>
    int tick, pre_tick;
    srand (time(NULL));
    Timer timer;
    timer.start();
    tick = timer.read_ms();
    pre_tick = tick;
    int lives = 3, level = 0, invuln = 0, diff = 0;
    // Initialize the buttons        
    left_pb.mode(PullUp);  // The variable left_pb will be zero when the pushbutton for moving the player left is pressed    
    right_pb.mode(PullUp); // The variable rightt_pb will be zero when the pushbutton for moving the player right is pressed        
    up_pb.mode(PullUp);    //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
    down_pb.mode(PullUp);  //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
     
    uLCD.cls();
    uLCD.locate(0,0);
    uLCD.printf("SELECT GAME MODE");
    uLCD.locate(0,4);
    uLCD.printf("1) EASY");
    uLCD.locate(0,8);
    uLCD.printf("2) MEDIUM");
    uLCD.locate(0,12);
    uLCD.printf("3) HARD");
    while(1){  
        if(down_pb == 0){
            diff = 1;
            break;
        }
        if(up_pb == 0){
            diff = 2;
            break;
        }
        if(right_pb == 0){
            diff = 3;
            break;
        }
    }   
    while(1)
    {
        /// [Example of the game control implementation]
        /// Here is the example to initialize the game <br><br>
        uLCD.cls();
        map_init();
        pacman_init(8,9); // Center of the map
        
    
        //Your code here
        //Initiate & create & show the ghosts  
        ghost_init();
        ghost_create(8,7,0xFF0000);
        if(diff > 0)
            ghost_create(7,5,0x00FF00);
        if(diff > 1)
            ghost_create(9,5,0xFFFF00);
        if(diff > 2)
            ghost_create(8,5,0x00FFFF);
        DLinkedList* ghostL = get_ghost_list();
        ghost_show(ghostL);
    
        //[Demo of play sound file]
        //playSound("/sd/wavfiles/BUZZER.wav");
    
        /// 1. Begin the game loop
        while(1){
            tick = timer.read_ms(); // Read current time
        
            /// 2. Implement the code to get user input and update the Pacman
            /// -[Hint] Implement the code to move Pacman. You could use either push-button or accelerometer. <br>
            /// The accelerometer's function readXYZGravity() might be useful. 
            if(left_pb == 0 && right_pb == 0){
                lives++;
                level++;
                break;
            }
            
            if(up_pb == 0 && down_pb == 0){
                lives = 0;
            }
            
            double x,y,z;
            acc.readXYZGravity(&x,&y,&z);
            if(x > .4 || left_pb == 0)
                pacman_set_action(PACMAN_HEADING_LEFT);
            if(x < -.4 || right_pb == 0)
                pacman_set_action(PACMAN_HEADING_RIGHT);
            if(y > .4 || down_pb == 0)
                pacman_set_action(PACMAN_HEADING_DOWN);
            if(y < -.4 || up_pb == 0)
                pacman_set_action(PACMAN_HEADING_UP);
            
            //uLCD.locate(0,1);
            //uLCD.printf("lives:%d",lives);
            
            
            GRID grid_info = map_get_grid_status(0,0);
            uLCD.filled_rectangle(grid_info.x,grid_info.y-GRID_SIZE,grid_info.x+(8*GRID_SIZE),grid_info.y,BACKGROUND_COLOR);
            int i = 0;
            while(i < lives){
                GRID grid_info = map_get_grid_status(i,0);
                int screen_x = grid_info.x + GRID_RADIUS;
                int screen_y = grid_info.y - GRID_RADIUS;
                uLCD.filled_circle(screen_x, screen_y, GRID_RADIUS, PACMAN_COLOR);
                uLCD.filled_rectangle(screen_x,screen_y-1,screen_x+GRID_SIZE,screen_y+1, BACKGROUND_COLOR);
                i++;
            }
            
        
            if((tick-pre_tick)>500){ // Time step control
                pre_tick = tick;
                
                
            /// 3. Update the Pacman on the screen
            /// -[Hint] You could update the position of Pacman here based on the input at step 2. <br>
                //pacman_update_position();
                
                invuln += pacman_update_position(level);
                
                if (invuln > 0){
                     pacman_add_score(ghost_collision(ghostL, pacman_get_x(), pacman_get_y(), invuln));
                     invuln -= 500;
                     myled = 1;
                }
                else{
                    if(ghost_collision(ghostL, pacman_get_x(), pacman_get_y(), invuln)){
                        lives -= ghost_collision(ghostL, pacman_get_x(), pacman_get_y(), invuln);
                        int j = 0;
                        while(j<10){
                            pacman_clear();
                            pacman_init(8,9);
                            j++;
                        }
                    }
                    myled = 0;
                }
                
                ghost_random_walk();
                
                if (invuln > 0){
                    pacman_add_score(ghost_collision(ghostL, pacman_get_x(), pacman_get_y(), invuln));
                }
                else{
                    if(ghost_collision(ghostL, pacman_get_x(), pacman_get_y(), invuln)){
                        lives -= ghost_collision(ghostL, pacman_get_x(), pacman_get_y(), invuln);
                        int j = 0;
                        while(j<10){
                            pacman_clear();
                            pacman_init(8,9);
                            j++;
                        }
                    }
                }
                
                ghost_show(ghostL);

            }
        
        /// 4. Implement the code to check the end of game.
        /// -[Hint] Check whether the ghost catch the Pacman. Make sure you could always detect that the ghost and Pacman meet on the screen.
        /// One tricky scenario is that: Pacman is at grid (3,3) and is heading to (3,4), while the ghost is at grid (3,4) and is heading to (3,3).
        /// Either at time t or t+1, you will see that the Pacman and the ghost are not on the same grid.
        /// However, the Pacman should be caught by ghost with this movement.
            if (lives == 0){
                pacman_clear();
                timer.stop();
                uLCD.locate(9,0);
                uLCD.printf("GAME OVER");
                
                if(up_pb == 0 && left_pb == 0){
                    lives = 3;
                    level = 0;
                    timer.start();
                    pacman_reset_score();
                    break;
                }
            } 
        /// -[Hint] Check whether Pacman win the game <br>
            if (map_remaining_cookie() == 0){
                lives++;
                level++;
                break;
            }
        }
    }
}



// Example of implementation of your functions
void playSound(char * wav)
{
    // open wav file
    FILE *wave_file;
    wave_file=fopen(wav,"r");

    // play wav file
    waver.play(wave_file);

    // close wav file
    fclose(wave_file);
}
