#include <stdlib.h>
#include <stdio.h>
#include "doubly_linked_list.h"

DLinkedList* create_dlinkedlist(void) {
    DLinkedList* newList = (DLinkedList*)malloc(sizeof(DLinkedList));
    newList->head = NULL;
    newList->tail = NULL;
    newList->current = NULL;
    newList->size = 0;
    return newList;
}

LLNode* create_llnode(void* data) {
    LLNode* newNode = (LLNode*)malloc(sizeof(LLNode));
    newNode->data = data;
    newNode->previous = NULL;
    newNode->next = NULL;
    return newNode;    
}

void insertHead(DLinkedList* dLinkedList, void* data){
  LLNode* newNode = create_llnode(data);
  if(dLinkedList->head == NULL){
    dLinkedList->size++;
    dLinkedList->head = newNode;
    dLinkedList->tail = newNode;
  }else{
    dLinkedList->size++;
    newNode->next = dLinkedList->head;
    (dLinkedList->head)->previous = newNode;
    dLinkedList->head = newNode;
  }
}


void insertTail(DLinkedList* dLinkedList, void* data){
  LLNode* newNode = create_llnode(data);
  if(dLinkedList->tail == NULL){
    dLinkedList->size++;
    dLinkedList->head = newNode;
    dLinkedList->tail = newNode;
  }else{
    dLinkedList->size++;
    newNode->previous = dLinkedList->tail;
    (dLinkedList->tail)->next = newNode;
    dLinkedList->tail = newNode;
  }
}

int insertAfter(DLinkedList* dLinkedList, void* newData){
  LLNode* newNode = create_llnode(newData);
  if(dLinkedList->current == NULL)
    return 0;
  else{
    if(dLinkedList->current == dLinkedList->tail){
	insertTail(dLinkedList, newData);
	return 1;
    }
    else{
    	dLinkedList->size++;
    	newNode->previous = dLinkedList->current;
    	newNode->next = (dLinkedList->current)->next;
   	((dLinkedList->current)->next)->previous = newNode;
    	(dLinkedList->current)->next = newNode;
	return 1;
    }
  }

}


int insertBefore(DLinkedList* dLinkedList, void* newData){
  LLNode* newNode = create_llnode(newData);
  if(dLinkedList->current == NULL)
    return 0;
  else{
    if(dLinkedList->current == dLinkedList->head){
	insertHead(dLinkedList, newData);
	return 1;
    }
    else{
    	dLinkedList->size++;
    	newNode->next = dLinkedList->current;
    	newNode->previous = (dLinkedList->current)->previous;
   	((dLinkedList->current)->previous)->next = newNode;
    	(dLinkedList->current)->previous = newNode;
	return 1;
    }
  }

}



void* deleteBackward(DLinkedList* dLinkedList){
  if(dLinkedList->current == NULL)
	return NULL;
  else{
	if(dLinkedList->current == dLinkedList->head){
		if((dLinkedList->current)->next == NULL){
		   free(dLinkedList->head);
		   dLinkedList->head = NULL;
		   dLinkedList->tail = NULL;
		   dLinkedList->current = NULL;
		   return NULL;
		}
		else{
		   dLinkedList->head = (dLinkedList->current)->next;
		   free((dLinkedList->head)->previous);
		   dLinkedList->current = NULL;
		   return NULL;
		}
	}
	else{
		if(dLinkedList->current == dLinkedList->tail){
		   dLinkedList->tail = (dLinkedList->current)->previous;
		   (dLinkedList->tail)->next = NULL;
		   free(dLinkedList->current);
		   dLinkedList->current = dLinkedList->tail;
		   return (dLinkedList->current)->data;	
		}
		else{
		   ((dLinkedList->current)->next)->previous = (dLinkedList->current)->previous;
		   ((dLinkedList->current)->previous)->next = (dLinkedList->current)->next;
		   free(dLinkedList->current);
		   dLinkedList->current = (dLinkedList->current)->previous;
		   return (dLinkedList->current)->data;
		}
	}
  }

}



void* deleteForward(DLinkedList* dLinkedList){
  if(dLinkedList->current == NULL)
	return NULL;
  else{
	if(dLinkedList->current == dLinkedList->tail){
		if((dLinkedList->current)->previous == NULL){
		   free(dLinkedList->tail);
		   dLinkedList->head = NULL;
		   dLinkedList->tail = NULL;
		   dLinkedList->current = NULL;
		   return NULL;
		}
		else{
		   dLinkedList->tail = (dLinkedList->current)->previous;
		   free((dLinkedList->tail)->next);
		   dLinkedList->current = NULL;
		   return NULL;
		}
	}
	else{
		if(dLinkedList->current == dLinkedList->head){
		   dLinkedList->head = (dLinkedList->current)->next;
		   (dLinkedList->head)->previous = NULL;
		   free((dLinkedList->head)->previous);
		   dLinkedList->current = dLinkedList->head;
		   return (dLinkedList->current)->data;	
		}
		else{
		   ((dLinkedList->current)->next)->previous = (dLinkedList->current)->previous;
		   ((dLinkedList->current)->previous)->next = (dLinkedList->current)->next;
		   free(dLinkedList->current);
		   dLinkedList->current = (dLinkedList->current)->next;
		   return (dLinkedList->current)->data;
	
		}
	}
  }
}


void destroyList(DLinkedList* dLinkedList){
  if(dLinkedList->head != NULL){
    getHead(dLinkedList);
    while(deleteForward(dLinkedList)){};
  }
  free(dLinkedList);
}



void* getHead(DLinkedList* dLinkedList){
  if (dLinkedList->head == NULL)
	return NULL;
  else{
	dLinkedList->current = dLinkedList->head;
	return (dLinkedList->head)->data;
  }
	
	
}



void* getTail(DLinkedList* dLinkedList){
  if (dLinkedList->tail == NULL)
	return NULL;
  else{
	dLinkedList->current = dLinkedList->tail;
	return (dLinkedList->tail)->data;
  }

}



void* getCurrent(DLinkedList* dLinkedList){
  if (dLinkedList->current == NULL)
	return NULL;
  else{
	return (dLinkedList->current)->data;
  }

}



void* getNext(DLinkedList* dLinkedList){
  if (dLinkedList->current == NULL || (dLinkedList->current)->next == NULL)
	return NULL;
  else{
	dLinkedList->current = (dLinkedList->current)->next;
	return (dLinkedList->current)->data;
  }

}



void* getPrevious(DLinkedList* dLinkedList){
  if (dLinkedList->current == NULL|| (dLinkedList->current)->previous == NULL)
	return NULL;
  else{
	dLinkedList->current = (dLinkedList->current)->previous;
	return (dLinkedList->current)->data;
  }

}


int getSize(DLinkedList* dLinkedList){
  return dLinkedList->size;

}


