#ifndef TLC59116_H
#define TLC59116_H

#include <mbed.h>

#define TLC59116_ADDRESS (0x60 << 1)

//********** REGISTER MAP DEFINITION
#define MODE1       0x00;
#define MODE2       0x01;
#define PWM0        0x02;
#define PWM1        0x03;
#define PWM2        0x04;
#define PWM3        0x05;
#define PWM4        0x06;
#define PWM5        0x07;
#define PWM6        0x08;
#define PWM7        0x09;
#define PWM8        0x0A;
#define PWM9        0x0B;
#define PWM10       0x0C;
#define PWM11       0x0D;
#define PWM12       0x0E;
#define PWM13       0x0F;
#define PWM14       0x10;
#define PWM15       0x11;
#define GRPPWM      0x12;
#define GRPFREQ     0x13;
#define LEDOUT0     0x14;
#define LEDOUT1     0x15;
#define LEDOUT2     0x16;
#define LEDOUT3     0x17;
#define SUBADR1     0x18;
#define SUBADR2     0x19;
#define SUBADR3     0x1A;
#define ALLCALLADR  0x1B;
#define IREF        0x1C;
#define EFLAG1      0x1D;
#define EFLAG2      0x1E;


//********** CONTROL REGISTER MASK DEFINITION
//  Auto Increment options
//  The CONTROL REGISTER three most significant bits contain the auto incrementing flag
//      and the five least significant the address the starting register address
//      A12 A11 A10 D4 D3 D2 D1 D0
//  The following #defines are masks setting the auto increment flag
//
//  * No auto increment
//  000 is used when the same register must be accessed several times during a single I2C bus communication,
//  for example, changing the brightness of a single LED. Data is overwritten each time the register
//  is accessed during a write operation.
#define AUTO_INCREMENT_NONE             0x00;   // mask = 000xxxxx
//  * Auto increment all registers
//  100 is used when all the registers must be sequentially accessed, for example, power-up programming.
#define AUTO_INCREMENT_ALL              0x80;   // mask = 100xxxxx
//  * Auto increment brightness
//  101 is used when the four LED drivers must be individually programmed with different values during the
//  same I2C bus communication, for example, changing a color setting to another color setting.
#define AUTO_INCREMENT_BRIGHTNESS       0xA0;   // mask = 101xxxxx
//  * Auto increment control
//  110 is used when the LED drivers must be globally programmed with different settings during the same
//  I2C bus communication, for example, global brightness or blinking change.
#define AUTO_INCREMENT_GLOBAL_CONTROL   0xC0;   // mask = 110xxxxx
//  * Auto increment brightness and control
//  111 is used when individually and global changes must be performed during the same
//  I2C bus communication, for example, changing color and global brightness at the same time.
#define AUTO_INCREMENT_BRIGHT_CONTROL   0xE0;   // mask = 111xxxxx
//**********

// TLC59116 Registers
#define COMMAND 0x00;


class TLC59116
{
    private:
        I2C _i2c;
        DigitalOut _cs;
        char b[32];
    public:
        TLC59116(PinName sda, PinName scl, PinName cs);
        void Enable(void);
        void Disable(void);
        int  SWRST(void);
        int  init(void);
        int  SetBrightness(int x);
        void SetAuto(bool v);
        void SetManual(bool v);
        void SetPower(bool v);
        void SetFault(bool v);
        void SetBarGraph(int x);
};

#endif