#include "TLC59116.h"

TLC59116::TLC59116(PinName sda, PinName scl, PinName cs) : _i2c(sda, scl), _cs(cs)
{
    for (int i = 0; i < sizeof(b); i++) b[i] = 0;               // clear internal buffer
    _i2c.frequency(400000);                                     // set i2c buffer frequency
}    

void TLC59116::Enable(void)
{
    _cs = 1;
    wait_ms(1);
}

void TLC59116::Disable(void)
{
    _cs = 0;
    wait_ms(1);
}

int TLC59116::SWRST()
{
    // TLC59116 SWRST
    b[0] = 0xA5;
    b[1] = 0x5A;
    return(_i2c.write(0xD6, b, 2));
}

int TLC59116::init(void)
{
    // TLC59116 FOO
    b[ 0] = AUTO_INCREMENT_ALL;             // COMMAND
    b[ 1] = 0x00;                           // MODE1
    b[ 2] = 0x00;                           // MODE2
    b[ 3] = 0xFF;                           // PWM0
    b[ 4] = 0xFF;                           // PWM1
    b[ 5] = 0xFF;                           // PWM2
    b[ 6] = 0xFF;                           // PWM3
    b[ 7] = 0xFF;                           // PWM4
    b[ 8] = 0xFF;                           // PWM5
    b[ 9] = 0xFF;                           // PWM6
    b[10] = 0xFF;                           // PWM7
    b[11] = 0xFF;                           // PWM8
    b[12] = 0xFF;                           // PWM9
    b[13] = 0xFF;                           // PWM10
    b[14] = 0xFF;                           // PWM11
    b[15] = 0xFF;                           // PWM12
    b[16] = 0xFF;                           // PWM13
    b[17] = 0xFF;                           // PWM14
    b[18] = 0xFF;                           // PWM15
    b[19] = 0xFF;                           // GRPPWM
    b[20] = 0x00;                           // GRPFREQ
    b[21] = 0x00;                           // LEDOUT0
    b[22] = 0x00;                           // LEDOUT1
    b[23] = 0x00;                           // LEDOUT2
    b[24] = 0x00;                           // LEDOUT3
    return(_i2c.write(TLC59116_ADDRESS, b, 25));
}

int TLC59116::SetBrightness(int x)
{
    b[0] = AUTO_INCREMENT_NONE;                    // set mask for no auto increment
    b[0] = b[0] | GRPPWM;                          // mask in group pwm control register
    b[1] = x;                                      // Brightness - PWM value between 0 and 255
    return(_i2c.write(TLC59116_ADDRESS, b, 2));
}

void TLC59116::SetAuto(bool v)
{
    b[0] = AUTO_INCREMENT_NONE;                     // set mask for no auto increment
    b[0] = b[0] | LEDOUT3;                          // mask in LEDOUT3 register
    _i2c.write(TLC59116_ADDRESS, b, 1);             // write register address
    _i2c.read(TLC59116_ADDRESS, b, 1);              // read register
    if (v)
        b[1] = b[0] | 0b00000011;
    else
        b[1] = b[0] & 0b11111100;
    b[0] = AUTO_INCREMENT_NONE;
    b[0] = b[0] | LEDOUT3;
    _i2c.write(TLC59116_ADDRESS, b, 2);
}

void TLC59116::SetManual(bool v)
{
    b[0] = AUTO_INCREMENT_NONE;                     // set mask for no auto increment
    b[0] = b[0] | LEDOUT3;                          // mask in LEDOUT3 register
    _i2c.write(TLC59116_ADDRESS, b, 1);             // write register address
    _i2c.read(TLC59116_ADDRESS, b, 1);              // read register
    if (v)
        b[1] = b[0] | 0b00001100;
    else
        b[1] = b[0] & 0b11110011;
    b[0] = AUTO_INCREMENT_NONE;
    b[0] = b[0] | LEDOUT3;
    _i2c.write(TLC59116_ADDRESS, b, 2);
}

void TLC59116::SetPower(bool v)
{
    b[0] = AUTO_INCREMENT_NONE;                     // set mask for no auto increment
    b[0] = b[0] | LEDOUT2;                          // mask in LEDOUT3 register
    _i2c.write(TLC59116_ADDRESS, b, 1);             // write register address
    _i2c.read(TLC59116_ADDRESS, b, 1);              // read register
    if (v)
        b[1] = b[0] | 0b00110000;
    else
        b[1] = b[0] & 0b11001111;
    b[0] = AUTO_INCREMENT_NONE;
    b[0] = b[0] | LEDOUT2;
    _i2c.write(TLC59116_ADDRESS, b, 2);
}

void TLC59116::SetFault(bool v)
{
    b[0] = AUTO_INCREMENT_NONE;                     // set mask for no auto increment
    b[0] = b[0] | LEDOUT2;                          // mask in LEDOUT3 register
    _i2c.write(TLC59116_ADDRESS, b, 1);             // write register address
    _i2c.read(TLC59116_ADDRESS, b, 1);              // read register
    if (v)
        b[1] = b[0] | 0b11000000;
    else
        b[1] = b[0] & 0b00111111;
    b[0] = AUTO_INCREMENT_NONE;
    b[0] = b[0] | LEDOUT2;
    _i2c.write(TLC59116_ADDRESS, b, 2);
}

// Set bar graph to value between zero and ten.
//  This routine sets the bar graph only
void TLC59116::SetBarGraph(int x)
{
    const int d[11][4] = {
        //LEDOUT0     LEDOUT1     LEDOUT2     LEDOUT3
        0b00000000, 0b00000000, 0b00000000, 0b00000000,     // 0
        0b00000000, 0b00000000, 0b00001100, 0b00000000,     // 1
        0b00000000, 0b00000000, 0b00001111, 0b00000000,     // 2
        0b00000000, 0b11000000, 0b00001111, 0b00000000,     // 3
        0b00000000, 0b11110000, 0b00001111, 0b00000000,     // 4
        0b00000000, 0b11111100, 0b00001111, 0b00000000,     // 5
        0b00000000, 0b11111111, 0b00001111, 0b00000000,     // 6
        0b11000000, 0b11111111, 0b00001111, 0b00000000,     // 7
        0b11110000, 0b11111111, 0b00001111, 0b00000000,     // 8
        0b11111100, 0b11111111, 0b00001111, 0b00000000,     // 9
        0b11111111, 0b11111111, 0b00001111, 0b00000000      // 10
    };

    // read current LED status
    b[0] = AUTO_INCREMENT_ALL;
    b[0] = b[0] | LEDOUT0;
    _i2c.write(TLC59116_ADDRESS, b, 1);
    _i2c.read(TLC59116_ADDRESS, b, 4);

    b[2] = b[2] & ~d[10][2]; // 0b11110000;
    b[2] = b[2] | d[x][2];

    b[4] = b[3];
    b[3] = b[2];
    b[2] = d[x][1];
    b[1] = d[x][0];
    b[0] = AUTO_INCREMENT_ALL;
    b[0] = b[0] | LEDOUT0;
    _i2c.write(TLC59116_ADDRESS, b, 5);

}
