#include "mbed.h"
#include "TLC59116.h"
#include "SWITCH.h"

Serial pc(PA_9, PA_10);                 // USB over serial USBTX, USBRX
DigitalOut led(PA_5);                   // Nucleo-F303RE LED
TLC59116 pdu(PB_7, PA_15, PB_11);       // TLC59116 LED driver in pdu SDA, SCL, CS
SWITCH sw(PB_15, PB_13, PB_1, PB_14);
bool fault = false;

int main()
{
    pdu.Enable();
    pdu.SWRST();
    pdu.init();
    #define DELAY 20
    
    pdu.SetBrightness(128);

    while(1)
    {
        pdu.SetPower(true);
        fault = !fault;
        pdu.SetFault(fault);
        if (sw.GetMode() == 1)
        {
            pdu.SetAuto(true);
            pdu.SetManual(false);
        }
        if (sw.GetMode() == 2)
        {
            pdu.SetAuto(false);
            pdu.SetManual(true);
        }
        

        pc.printf("GetMode = %x\r\n", sw.GetMode());
        pc.printf("GetMove = %x\r\n", sw.GetMove());        
        pc.printf("\r\n");
        
        for (int i = 0; i <= 10; i++)
        {
            pdu.SetBarGraph(i);
            wait_ms(DELAY);
        }
        
        for (int i = 10; i >= 0; i--)
        {
            pdu.SetBarGraph(i);
            wait_ms(DELAY);
        }
    }
}