#include "mbed.h"
#include "SerialRPCInterface.h"
//#include "MODSERIAL.h"
#define DELAY 250

AnalogIn mtr_pos(PA_0);
PwmOut udp_pwm(PA_4);
PwmOut mp_pwm(PB_7);
PwmOut airspeed_pwm(PB_6);
PwmOut rpm_pwm(PA_8);
PwmOut ff_pwm(PA_1);

DigitalOut myled(LED1);
SerialRPCInterface rpc(PA_9, PA_10, 115200);       // create serial rpc interface on usb virtual com port

float mtr_pos_vout = 0.0f;
float udp_vout = 0.0f;
float mp_vout = 0.0f;
float airspeed_vout = 0.0f;
float ff_f = 0.0f;
float rpm_f = 0.0f;
float temp = 0.25f;
volatile char   c = '\0'; // Initialized to the NULL character

RPCVariable<float>  rpc_mtr_pos_vout(&mtr_pos_vout, "mtr_pos_vout");
RPCVariable<float>  rpc_udp_vout(&udp_vout, "udp_vout");
RPCVariable<float>  rpc_mp_vout(&mp_vout, "mp_vout");
RPCVariable<float>  rpc_airspeed_vout(&airspeed_vout, "airspeed_vout");
RPCVariable<float>  rpc_ff_f(&ff_f, "ff_f");
RPCVariable<float>  rpc_temp(&temp, "temp");

int pwm_v(float x)
{
    return (-4.6206 * x * x * x * x) + (64.395f * x * x * x) - (329.67f * x * x) + (877.84f * x) - 294.19f;
}

float pwm_ff(float x)
{
    return 1/x;
}

int main() {

    udp_pwm.period_us(1000);
    udp_pwm.pulsewidth_us(666);

    mp_pwm.period_us(1000);
    mp_pwm.pulsewidth_us(600);

    airspeed_pwm.period_us(1000);
    airspeed_pwm.pulsewidth_us(500);
    
    ff_f = 300.0f;
    ff_pwm.period(1/ff_f);
    ff_pwm.pulsewidth_us((1/ff_f)/2);

    rpm_f = 400.0f;
    rpm_pwm.period(1/rpm_f);
    rpm_pwm.pulsewidth((1/rpm_f)/2);
    
    //rpc.Disable();

    while(1) {

        myled = !myled; // pulse LED
        
        mtr_pos_vout = mtr_pos.read();
        
        udp_pwm.pulsewidth_us(pwm_v(udp_vout));
        mp_pwm.pulsewidth_us(pwm_v(mp_vout));
        airspeed_pwm.pulsewidth_us(pwm_v(airspeed_vout));

        rpm_pwm.period(1/rpm_f);
        rpm_pwm.pulsewidth((1/rpm_f)/2);
        ff_pwm.period(1/ff_f);
        ff_pwm.pulsewidth((1/ff_f)/2);

        //rpc.Enable();
        wait_ms(DELAY);
        //rpc.Disable();
    }
}
