// motor test firmware
// STM32F303 version 1.0
// 2016-12-19
// Cheldelin

#include "mbed.h"                                   // main mbed library
#include "SerialRPCInterface.h"                     // mbed rpc library for serial rpc communication to Labview
#include "dsp.h"                                    // mbed cmsis arm library for PID control
#include "STM32F303_L6470_v1.h"                     // L6470 stepper motor conrol interface for ST

#define OFF 0
#define ON 1

// Global objects
DigitalOut led_green(PB_3);                         // active low to turn on green part of RGB LED on FRDM-K22F

SerialRPCInterface rpc(USBTX, USBRX, 115200);       // create serial rpc interface on usb virtual com port
L6470 motor(PA_7, PA_6, PA_5, PA_4);                // create motor object with mosi, miso, sclk, cs on NUCLEO STMF303

int   direction;                                    // global holds current direction to move motor, either OPEN or CLOSE
float distance_1;                                   // global holds current distance to move motor in steps
float distance_2;
float position = 0;

// RPC variable assignments
RPCVariable<int>   rpc_position(&motor.position, "position");
RPCVariable<int>   rpc_range(&motor.range, "range");
RPCVariable<int>   rpc_direction(&direction, "direction");
RPCVariable<float> rpc_distance_1(&distance_1, "distance_1");
RPCVariable<float> rpc_distance_2(&distance_2, "distance_2");

int main(){

    // Turn off LED
    led_green = OFF;

    // delay to allow L6470 to power up
    // TODO:  set up digital pin on BUSY and/or FLAG pin for feedback
    wait_ms(1000);

    // Set the default motor parameters
    motor.SetDefaultParameters();

    // troubleshooting???
    motor.HardStop();
    motor.SoftHIZ();
    wait_ms(1000);

    // set step mode
    uint32_t StepMode = motor.GetParameter(STEP_MODE);
    StepMode = StepMode & 0xfffffff0;  // turn off microstepping
    //StepMode = StepMode + 0x00; // new step mode 0x00 thru 0x07
    motor.SetParameter(STEP_MODE, StepMode);   // set step mode
    motor.ResetPosition();
    
    // Main loop
    while(1){
        uint16_t MaxSpeed = 0x6f;
        uint16_t MaxTime = 1400;
        
        // close full speed
        led_green = ON;
        motor.SetParameter(MAX_SPEED, MaxSpeed);
        //motor.SpeedRun(CLOSE, 0x0010);
        motor.Move(CLOSE, 1400);
        wait_ms(MaxTime);

        // open full speed
        led_green = OFF;
        motor.SetParameter(MAX_SPEED, MaxSpeed);
        //motor.SpeedRun(CLOSE, 0x0004ff);
        motor.Move(OPEN, 1400);
        wait_ms(MaxTime);

        // close half speed
        led_green = ON;
        motor.SetParameter(MAX_SPEED, MaxSpeed >> 1);
        //motor.SpeedRun(CLOSE, 0x0010);
        motor.Move(CLOSE, 1400);
        wait_ms(MaxTime << 1);

        // open half speed
        led_green = OFF;
        motor.SetParameter(MAX_SPEED, MaxSpeed >> 1);
        //motor.SpeedRun(CLOSE, 0x0004ff);
        motor.Move(OPEN, 1400);
        wait_ms(MaxTime << 1);

        // close quarter speed
        led_green = ON;
        motor.SetParameter(MAX_SPEED, MaxSpeed >> 2);
        //motor.SpeedRun(CLOSE, 0x0010);
        motor.Move(CLOSE, 1400);
        wait_ms(MaxTime << 2);

        // open quarter speed
        led_green = OFF;
        motor.SetParameter(MAX_SPEED, MaxSpeed >> 2);
        //motor.SpeedRun(CLOSE, 0x0004ff);
        motor.Move(OPEN, 1400);
        wait_ms(MaxTime << 2);

        uint8_t KVal  = 0x05;
        motor.SetLowSpeedOpt(OFF);          // turn of low speed optimization
        // close eighth speed
        led_green = ON;
        motor.SetParameter(KVAL_RUN, KVal);
        motor.SetParameter(MAX_SPEED, MaxSpeed >> 3);
        //motor.SpeedRun(CLOSE, 0x0010);
        motor.SetParameter(KVAL_RUN, 0x0F);   // increase motor drive at slowest speed
        motor.Move(CLOSE, 1400);
        motor.SetParameter(KVAL_RUN, KVal);   // set motor drive back to default
        wait_ms(MaxTime << 3);

        // open eighth speed
        led_green = OFF;
        motor.SetParameter(MAX_SPEED, MaxSpeed >> 3);   // increase motor drive at slowest speed
        //motor.SpeedRun(CLOSE, 0x0004ff);
        motor.SetParameter(KVAL_RUN, 0x0F);                   // set motor drive back to default
        motor.Move(OPEN, 1400);
        motor.SetParameter(KVAL_RUN, KVal);
        wait_ms(MaxTime << 3);

        led_green = ON;
        KVal =  0x10;
        motor.SetLowSpeedOpt(ON);          // turn of low speed optimization
        // close eighth speed
        motor.SetParameter(KVAL_RUN, KVal);
        motor.SetParameter(MAX_SPEED, MaxSpeed >> 3);
        //motor.SpeedRun(CLOSE, 0x0010);
        motor.SetParameter(KVAL_RUN, 0x0F);   // increase motor drive at slowest speed
        motor.Move(CLOSE, 1400);
        motor.SetParameter(KVAL_RUN, KVal);   // set motor drive back to default
        wait_ms(MaxTime << 3);

        // open eighth speed
        led_green = OFF;
        motor.SetParameter(MAX_SPEED, MaxSpeed >> 3);   // increase motor drive at slowest speed
        //motor.SpeedRun(CLOSE, 0x0004ff);
        motor.SetParameter(KVAL_RUN, 0x0F);                   // set motor drive back to default
        motor.Move(OPEN, 1400);
        motor.SetParameter(KVAL_RUN, KVal);
        wait_ms(MaxTime << 3);
        led_green = 0;

    }
}