/* =========================================================================================
*                     GSM_MQTT == MQTT CLIENT LIBRARY FOR GPRS MODEM
* SUPPORTED GPRS MODEM ==> SIM800, SIM900, SIM300
* SUPPORTED MBED HARDWARE ==> Any hardware with two Hardware Serial port and 1 timer
*
* Developed By : Ravi Butani
* Prof. Marwadi University, Rajkkot-INDIA
* Contact: ravi_butani@yahoo.com
*
* License : This library released under CC-BY-SA 4.0 license
* https://creativecommons.org/licenses/by-sa/4.0/legalcode.txt
*
* This library is derived from Arduino MQTT Client for SIM800 at 
* https://github.com/elementzonline/SIM800_MQTT
*============================================================================================*/

#include "mbed.h"
#include "GSM_MQTT.h"

Serial SerialDBG(USBTX, USBRX);   // tx, rx for USB Debug on PC
Serial Serial800(D8, D2);         // tx, rx for SIM800 Interfacing on UART

string MQTT_HOST = "iot.eclipse.org";
string MQTT_PORT = "1883";

void GSM_MQTT::AutoConnect(void)
{
  connect("client657");
}

void GSM_MQTT::OnConnect(void)
{
  subscribe("ravibut");
  publish("SampleTopic", "Hello");
}

void GSM_MQTT::OnMessage(char *Topic, int TopicLength, char *Message, int MessageLength)
{
  SerialDBG.printf("%d \r\n",TopicLength);
  SerialDBG.printf("%s \r\n",Topic);
  SerialDBG.printf("%d \r\n",MessageLength);
  SerialDBG.printf("%s \r\n",Message);
}

GSM_MQTT MQTT(20);
int main()
{
  SerialDBG.printf("Wait for 3 seconds to get SIM800 stabilized...\r\n");
  wait(3);
  MQTT.begin();
  
    while(1)
    {
        wait(3);
        if (MQTT.available())
        {
            SerialDBG.printf("mqtt_ok\r\n");
            MQTT.publish("SampleTopic", "Hello");
        }
        MQTT.processing();
    }
}
