#ifndef ADT7320_SPI_H
#define ADT7320_SPI_H
 
/**
 * Includes
 */
#include "mbed.h"


class ADT7320_SPI {
 
 public:

    /**
     * Constructor.
     *
     * @param mosi mbed pin to use for SDA line of I2C interface.
     * @param sck mbed pin to use for SCL line of I2C interface.
     */
    ADT7320_SPI(PinName mosi, PinName miso, PinName sclk, PinName cs);
    float readTemp(void);
    /**
     * Get the output of all three axes.
     *
     * @param Pointer to a buffer to hold the accelerometer value for the
     *        x-axis, y-axis and z-axis [in that order].
     */
     
 
 private:

    SPI spi_;
    DigitalOut cs_;
    unsigned int readRegister(uint8_t thisRegister, int bytesToRead );
    /**
     * Read one byte from a register on the device.
     *
     * @param: - the address to be read from
     *
     * @return: the value of the data read
     */
    

    /**
     * Write one byte to a register on the device.
     *
     * @param:
        - address of the register to write to.
        - the value of the data to store
     */
  
   
};
 
#endif 