#include "ADT7320_SPI.h"

//#include "mbed.h"

ADT7320_SPI::ADT7320_SPI(PinName mosi, PinName miso, PinName sclk, PinName cs) : spi_(mosi, miso, sclk),cs_(cs) {
    // Chip must be deselected
    cs_ = 1;
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi_.format(8,3);
    spi_.frequency(1000000);
}

//Read from register from the ADT7320:
unsigned int ADT7320_SPI::readRegister(uint8_t thisRegister, int bytesToRead ) {
  uint8_t inByte = 0;          // incoming byte from the SPI
  unsigned int result = 0;  // result to return
  // take the chip select low to select the device:
  cs_=0;
  // send the device the register you want to read:
  spi_.write(thisRegister);
  // send a value of 0 to read the first byte returned:
  result = spi_.write(0xFF);
  // decrement the number of bytes left to read:
  bytesToRead--;
  // if you still have another byte to read:
  if (bytesToRead > 0) {
    // shift the first byte left, then get the second byte:
    result = result << 8;
    inByte = spi_.write(0xFF);
    // combine the byte you just got with the previous one:
    result = result | inByte;
    // decrement the number of bytes left to read:
    bytesToRead--;
  }
  // take the chip select high to de-select:
  cs_=1;
  // return the result:
  return(result);
}

float ADT7320_SPI::readTemp(void)
{
    //Read the temperature data
    unsigned int tempData = readRegister(0x50, 2); // 0x50 is read commad for 0x02 register
    tempData = tempData/8;// MSB bit15 and LSB bit4 so received value need to be divide/8

    // convert the temperature to celsius and display it:
    float realTemp = (float)tempData * 0.0625;
    return realTemp;  
}
     