#include "mbed.h"

/*------------------------------------------------------------------------------
Before to use this example, ensure that you an hyperterminal installed on your
computer. More info here: https://developer.mbed.org/handbook/Terminals

The default serial comm port uses the SERIAL_TX and SERIAL_RX pins (see their
definition in the PinNames.h file).

The default serial configuration in this case is 9600 bauds, 8-bit data, no parity

If you want to change the baudrate for example, you have to redeclare the
serial object in your code:

Serial pc(SERIAL_TX, SERIAL_RX);

Then, you can modify the baudrate and print like this:

pc.baud(115200);
pc.printf("Hello World !\n");
------------------------------------------------------------------------------*/

// Defines
# define SIZE_OF_BUFFER 5              
# define A_MINUTE 60000

//Global Variables
int RPeakValuesRead[] = {8584,9468,10388,11280,12164, //These values are in milliseconds
                         13060,13948,14798,15660,16506,
                         17352,18202,19016,19868,20740,
                         21608,22490,23368,24238,25098,
                         25968,26844,27004,28546,29496};

float RRIntervalBuffer[] = {0,0,0,0,0};

// Declared Functions
float GetAverage(void);                    



int main()
{
    DigitalOut led(LED1);
    
    // Initialize Variables
    int RRInterval = 0;
    int PreviousValue = 0;
    int CurrentValue = 0;
    int Index = 0;
    int Counter = 0;
    float BPM = 0;
    
    int SizeOfArray = *(&RPeakValuesRead + 1) - RPeakValuesRead; // gets the size of the array to use in for loop
    while(1) 
    {
        for(int i = 0; i < SizeOfArray; i++) // iterates through RPeaValuesRead Array
        {
            PreviousValue = CurrentValue; // [x][x][x][1][x]
            CurrentValue = RPeakValuesRead[i]; // [x][x][x][1][1]
            
            if(CurrentValue > PreviousValue && (CurrentValue - PreviousValue != CurrentValue)) // simple check so there are no unexpected values
            {
                RRInterval = CurrentValue - PreviousValue;  // gets the RRInterval
                
                printf("RR Interval is %d \r\n", RRInterval);
                
                if(RRInterval > 1500 || RRInterval < 300)
                {
                    printf("--BPM\r\n");
                }
                           
                if(RRInterval < 1500 && RRInterval > 300) // if the RRInterval is between 300ms and 1500ms then it is credible
                {
                    RRIntervalBuffer[Index] = RRInterval; // Store RRInterval for working out average later

                    
                    Index += 1; // used for moving average buffer
                    Counter += 1; // used with helping determine when the moving average can be calculated
                    
                    if(Counter < 4) // if there isn't enough data then we can't determine if there is a BPM
                    {
                        printf("--BPM\r\n");
                    }
                    if(Counter > 4) // when there is enough data then work out the moving average
                    {
                        BPM = A_MINUTE/GetAverage();
                        printf("BPM = %.1F\r\n", BPM);
                        if(Counter % SIZE_OF_BUFFER == 0) // If counter is modulus of SIZE_OF_BUFFER then set index to 0
                        {
                            Index = 0;
                        }
                        led = !led; // Toggle LED
                        wait(0.5);
                        led = !led; // Toggle LED
                    }
                }
            }
            wait(0.5);
        }
    }
}



// This function gets the average of the variables in RRIntervalBuffer
float GetAverage()
{
    float Average = 0;
    
    for(int i=0; i<SIZE_OF_BUFFER; i++) // iterate through the array and add the values together
    {
        Average+=RRIntervalBuffer[i];    
    }
    
    Average/=SIZE_OF_BUFFER; // get the average of the 5 values
    
    printf("Average is %.1F\r\n", Average);
    
    return Average;
}