#include "mbed.h"
#include "freetronicsLCDShield.h"
#include "buffer.h"
#include "CommandPacket.h"
#include "SerialInterfaceProtocol.h"

// #define DEBUG_MESSAGE
 
freetronicsLCDShield lcd(D8, D9, D4, D5, D6, D7, D10, A0); // rs, e, d0, d1, d2, d3, bl, a0
Serial pc(USBTX, USBRX);
CircularBuffer<uint8_t> SerialInputBuffer;
CircularBuffer<uint8_t> SerialOutputBuffer;
SerialInterfaceProtocol SIP(&SerialInputBuffer, &SerialOutputBuffer);

void serialInterruptHandler() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    int c = pc.getc();
    
    // add to buffer
    if (SerialInputBuffer.isLocked())
    {
        printf("Mutex Locked\r\n");
    }
    else
    {
        SerialInputBuffer.enqueue((uint8_t) c);   
    }
}

int toggleLcdBackLight(uint8_t *payload, uint8_t payload_length, uint8_t *response, uint8_t *response_length)
{    
    // wrong payload length
    if (payload_length != 1)
    {
        sprintf((char *) response, "Wrong Payload Length\r\n");
        *response_length = 22;
        return 1;
    }
    
    // get payload
    bool lcdBackLight = (bool) payload[0];
    
    // set back light
    lcd.setBackLight(lcdBackLight);
    
    return 0;
}

int setLcdBackLightIntensity(uint8_t *payload, uint8_t payload_length, uint8_t *response, uint8_t *response_length)
{    
    // set intensity
    lcd.setBackLight((float) atof((char*) payload));
    
    return 0;
}

int resetLcd(uint8_t *payload, uint8_t payload_length, uint8_t *response, uint8_t *response_length)
{    
    // no payload
    if (payload_length != 0)
    {
        sprintf((char *) response, "Wrong Payload Length\r\n");
        *response_length = 22;
        return 1;
    }
    
    // reset display and settings
    lcd.cls();
    
    return 0;
}

int setLcdCursorPosition(uint8_t *payload, uint8_t payload_length, uint8_t *response, uint8_t *response_length)
{
    // two payloads
    if (payload_length != 2)
    {
        sprintf((char *) response, "Wrong Payload Length\r\n");
        *response_length = 22;
        return 1;
    } 
    
    // set current cursor location
    lcd.setCursorPosition(
        (bool) payload[0],
        (bool) payload[1]
    );
    
    return 0;
}

int setLcdCursorProperty(uint8_t *payload, uint8_t payload_length, uint8_t *response, uint8_t *response_length)
{
    // two payloads
    if (payload_length != 2)
    {
        sprintf((char *) response, "Wrong Payload Length\r\n");
        *response_length = 22;
        return 1;
    } 
    
    lcd.setCursor(
        (bool) payload[0],
        (bool) payload[1]
    );
    
    return 0;
}

int lcdPrintToLine(uint8_t *payload, uint8_t payload_length, uint8_t *response, uint8_t *response_length)
{    
    // set cursor position
    lcd.setCursorPosition(payload[0], 0);
    
    // print to screen
    lcd.printf((char *) (payload + 1));
    
    return 0;
}

int lcdAppendPrint(uint8_t *payload, uint8_t payload_length, uint8_t *response, uint8_t *response_length)
{   
    // print to screen
    lcd.printf((char *) payload);
    
    return 0;
}

int toggleChecksum(uint8_t *payload, uint8_t payload_length, uint8_t *response, uint8_t *response_length)
{
    // one payload
    if (payload_length != 1)
    {
        sprintf((char *) response, "Wrong Payload Length\r\n");
        *response_length = 22;
        return 1;
    } 
    
    if ((bool) payload[0])
    {
        SIP.enableChecksum();
    }
    else
    {
        SIP.disableChecksum();
    }
    
    return 0;
}

int setBaudRate(uint8_t *payload, uint8_t payload_length, uint8_t *response, uint8_t *response_length)
{  
    int baudRate = atoi((char *)payload);
    
    // set baud rate
    pc.baud(baudRate);
    
    return 0;
}

int echoPayload(uint8_t *payload, uint8_t payload_length, uint8_t *response, uint8_t *response_length)
{
    memcpy(response, payload, payload_length);
    *response_length = payload_length;

    return 0;
}
 
int main() {
    // turn on the back light (it's off by default)
    lcd.setBackLight(true);
    lcd.setCursor(true, true);
    lcd.cls();
    
    pc.attach(&serialInterruptHandler);
    
    // control
    SIP.registerCommand(0x00, toggleChecksum);
    SIP.registerCommand(0x01, setBaudRate);
    
    // misc
    SIP.registerCommand(0xe0, echoPayload);
    
    // lcd
    SIP.registerCommand(0xf0, toggleLcdBackLight);
    SIP.registerCommand(0xf1, setLcdBackLightIntensity);
    SIP.registerCommand(0xf2, resetLcd);
    SIP.registerCommand(0xf3, setLcdCursorPosition);
    SIP.registerCommand(0xf4, setLcdCursorProperty);
    SIP.registerCommand(0xf5, lcdPrintToLine);
    SIP.registerCommand(0xf6, lcdAppendPrint);
    
    
    
    while (1)
    {
        SIP.poll();
        // button event
        switch (lcd.readButton())
        {
            case freetronicsLCDShield::BTN_SELECT:
                lcd.cls();
                break;
            case freetronicsLCDShield::BTN_UP:
                break;
            case freetronicsLCDShield::BTN_DOWN:
                break;
            case freetronicsLCDShield::BTN_LEFT:
                break;
            case freetronicsLCDShield::BTN_RIGHT:
                break;
            default:
                break;
        }
        
        
        // extract buffer
        while (SerialOutputBuffer.getCounter() > 0)
        {
            uint8_t ch;
            ch = SerialOutputBuffer.dequeue();
            pc.putc(ch);
        }
    }
}