#include "mbed.h"
#include "Hexi_KW40Z.h"
#include "Hexi_OLED_SSD1351.h"
#include "OLED_types.h"
#include "OpenSans_Font.h"
#include "string.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define LED_ON      0
#define LED_OFF     1
#define MPL3115A2_I2C_ADDRESS (0x60<<1)

void StartHaptic(void);
void StopHaptic(void const *n);



DigitalOut redLed(LED1,1);
DigitalOut greenLed(LED2,1);
DigitalOut WHITELed(LED3,1);
DigitalOut haptic(PTB9);
DigitalOut sensorPowerEn(PTB12);
DigitalOut powerEN (PTB12);
DigitalOut led1(LED_GREEN); // RGB LED
Serial pc(USBTX,USBRX); // Serial interface

char text[20]; // Text Buffer for dynamic value displayed
char text1[20]; // Text Buffer for dynamic value displayed
char text2[20]; // Text Buffer for dynamic value displayed
char text3[20]; // Text Buffer for dynamic value displayed
char text4[20]; // Text Buffer for dynamic value displayed

/* Define timer for haptic feedback */
RtosTimer hapticTimer(StopHaptic, osTimerOnce);

/* Instantiate the Hexi KW40Z Driver (UART TX, UART RX) */
KW40Z kw40z_device(PTE24, PTE25);

/* Instantiate the SSD1351 OLED Driver */
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); /* (MOSI,SCLK,POWER,CS,RST,DC) */
//void page_1(void);




/****************************Call Back Functions*******************************/


void ButtonRight(void)
{
    StartHaptic();
    pc.printf("opoooooooo");

}

void ButtonLeft(void)
{
    StartHaptic();

}

void ButtonDown(void)
{

    StartHaptic();
    pc.printf("down");

}

void ButtonUp(void)
{
    StartHaptic();
    pc.printf("up once");

}

void ButtonSlide(void)
{
    StartHaptic();
}
void PassKey(void)
{
    StartHaptic();
    strcpy((char *) text,"PAIR CODE");
    oled.TextBox((uint8_t *)text,0,25,95,18);

    /* Display Bond Pass Key in a 95px by 18px textbox at x=0,y=40 */
    sprintf(text,"%d", kw40z_device.GetPassKey());
    oled.TextBox((uint8_t *)text,0,40,95,18);
}

/***********************End of Call Back Functions*****************************/





/********************************Main******************************************/


int pages[5];

int row_count = 0;

void pag_1(){
    
    
    pc.printf("page1\n");
    }
void pag_2(){
    
    
    pc.printf("page2\n");
    }

void pag_3(){
    
    
    pc.printf("page3\n");
    }

void pag_4(){
    
    
    pc.printf("page4\n");
    }
void pag_5(){
    
    
    pc.printf("page5\n");
    }
void switch_page (int count)
{
    //This function checks
    //the int value of the count to determine what page to load to the screen
    switch (count) {
        //checks and calls appropriate function
        case 0:
            // pull first page function
            pag_1();
            break;

        case 1:
            // pull 2nd  page function
            pag_2();
            break;

        case 2:
            // pull 3rd page function
            pag_3();
            break;

        case 3:
            // pull 4th page function
            pag_4();
            break;


        case 4:
            // pull 5th page function
            pag_5();
            break;

        default:
            // Do nothing
            break;

    }

}
 
void ButtonTouch()
{
  StartHaptic();
    
  //  typedef int(*pageFunction)();
  //  pageFunction page_1 = pag_1;
    
   
       switch_page(row_count);
        if (row_count > 4) row_count = 4;
         
         row_count++;
}


void ButtonTouch2()
{
  StartHaptic();
    
 //   typedef int(*pageFunction)();
 //   pageFunction page_1 = pag_1;
    
   
       
        if (row_count > 4) row_count = 4;
        row_count--;
        switch_page(row_count);
}

int main()
{
    
    

    //kw40z_device.ToggleAdvertisementMode();
    /* Register callbacks to application functions */
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);
    kw40z_device.attach_passkey(&PassKey);
    kw40z_device.attach_buttonDown(&ButtonDown);
    kw40z_device.attach_buttonUp(&ButtonUp);
    kw40z_device.PageIndex(&ButtonTouch);
    kw40z_device.PageIndex2(&ButtonTouch2);


    /* Turn on the backlight of the OLED Display */
    oled.DimScreenON();
    /* Fills the screen with solid black */
    oled.FillScreen(COLOR_BLACK);
    /* Get OLED Class Default Text Properties */
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);
    oled.FillScreen(COLOR_BLACK);

    while (true) {
    
        Thread::wait(0.1);
        WHITELed = !kw40z_device.GetAdvertisementMode(); /*Indicate BLE Advertisment Mode*/
        Thread::wait(50);
    }
}

/******************************End of Main*************************************/


void StartHaptic(void)
{
    hapticTimer.start(50);
    haptic = 1;
}

void StopHaptic(void const *n)
{
    haptic = 0;
    hapticTimer.stop();
}

    

