
#include "GYROMETER.h"
 #include "mbed.h"

GYROMETER::GYROMETER(PinName sda, PinName scl) : gyroi2c(sda,scl)
 {

 }

 void GYROMETER::Config(void)
 {
   char d[2];
   d[0] = GYRO_CTRL_REG1;                       //standby mode
   d[1] = 0x08;
   gyroi2c.write(GYRO_I2C_ADDRESS, d,2);


   d[0] = GYRO_CTRL_REG0;
   d[1] = 0x00;
   gyroi2c.write(GYRO_I2C_ADDRESS, d, 2);


   d[0] = GYRO_CTRL_REG1;                       // active mode
   d[1] = 0x0A;
   gyroi2c.write(GYRO_I2C_ADDRESS, d,2);

 }

 void GYROMETER::getData(float * g_data)
 {

    char data_bytes[7];
   gyroi2c.write(GYRO_I2C_ADDRESS,GYRO_STATUS,1,true);  // Read the 6 data bytes
   gyroi2c.read(GYRO_I2C_ADDRESS,data_bytes,7);

   g_data[0] =  (float)((int16_t)((data_bytes[1]*256) + (data_bytes[2]))) * 0.0625;
   g_data[1] =  (float)((int16_t)((data_bytes[3]*256) + (data_bytes[4]))) * 0.0625;
   g_data[2] =  (float)((int16_t)((data_bytes[5]*256) + (data_bytes[6]))) * 0.0625;

 }





