
#include "mbed.h"

// Acquired from Datasheet.
 
#define HTU21D_I2C_ADDRESS  0x40 
#define TRIGGER_TEMP_MEASURE  0xE3
#define TRIGGER_HUMD_MEASURE  0xE5
 
 
//Commands.
#define HTU21D_EEPROM_WRITE 0x80
#define HTU21D_EEPROM_READ  0x81

#ifndef HTU21D_H
#define HTU21D_H

 
/**
 * MOONSHOT HTU21D digital humidity and temperature sensor.
 */
class HTU21D {
 
public:
 

    HTU21D(PinName sda, PinName scl);
 
 
    //    GET SAMPLES FOR TEMP(in Celcuis)
    int sampleTemp_cel(void);
    
  //    GET SAMPLES FOR TEMP(in  fahrenheit)
    int sampleTemp_fah(void);
    
  //    GET SAMPLES FOR TEMP(in  Kelvin)
    int sampleTemp_kel(void);
    
// SAMPLES OF HUMIDITY 
    int sample_Humid(void);
 
   
 
private:
 
    I2C* i2c_;
 

    void write(int EepromOrRam, int address, int data);   // writing to EEPROM or Ram (destination, address to write to, data to write)
 

    int read(int EepromOrRam, int address);  //Reading from EEprom (destination, add to read from)
 
};
 
#endif /* HTU21D_H */
 
