#include "StateMachine.h"
#include "mbed.h"
#include "EthernetInterface.h"

//TCP Server atribute
DigitalOut led(LED1);


//TCP Cleint atribute
DigitalOut led(LED1);
AnalogIn pot1 (A0);
AnalogIn pot2 (A1);
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
LM75B sensor(D14,D15);

uint16_t temp = sensor.read();
uint8_t upper = (temp >> 8) & 0x00FF;
uint8_t lower = temp & 0x00FF;
uint8_t PWM = pot1.read();
uint8_t ID = 4;
char payload[4] = {upper, lower, PWM, ID};



StateMachine::StateMachine()
{
    currentState = LISENING;
}


void StateMachine::start()
{
    while(true) {
        up_down();
        switch(currentState) {
            case LISENING:
                actionlisten(); // na listen
                currentState = SENDING;
                break;
            case SENDING:
                actionrecive(); // na sending
                currentState = LISENING;
                break;
        }
    }
}

void StateMachine::actionlisten() // Client
{

    printf("Client example\n\r");
    EthernetInterface eth;
    eth.set_network("192.168.0.4","255.255.255.0","192.168.0.1"); // ip/mask/deffault gateway 
    eth.connect();
    printf("The client IP address is '%s'\n\r", eth.get_ip_address());
    printf("%d\n", upper);  // aflezen 


    TCPSocket socket;
    socket.open(&eth);
    socket.connect("192.168.0.28",4000);

    char rbuffer[4];

    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    printf("received: %d\r\n", rcount);


    printf(rbuffer);
    socket.send(payload, 4);
    socket.close();

}

void StateMachine::actionrecive() // Server
}

printf("Server example\n\r");

EthernetInterface eth;
eth.set_network("192.168.0.40","255.255.255.0","192.168.0.1");
eth.connect();

printf("The Server IP address is '%s'\n\r", eth.get_ip_address());

TCPServer srv(&eth);

srv.bind(4000);

srv.listen();

while(true)
{
    TCPSocket client;
    SocketAddress client_addr;
    char *buffer = "Hello TCP client!\r\n";

    srv.accept(&client, &client_addr);

    printf("Accepted %s:%d\n\r", client_addr.get_ip_address(),
           client_addr.get_port());

    client.send(buffer, 256);

    client.close();

}
