#if 1

/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LCD.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    1000

DigitalOut statusled(PC_0);
InterruptIn taste1(PA_1);
InterruptIn taste2(PA_6);
lcd meinLCD;
void isr_aus()
{
     statusled=0;
}
void isr_ein()
{
     statusled=1;
}

int main()
{
    // Initialise the digital pin LED1 as an output
    int zaehler=0;
    DigitalOut led(LED1);
    taste1.mode(PullDown);
    taste2.mode(PullDown);
    taste1.rise(&isr_aus);
    taste2.rise(&isr_ein);
    taste1.enable_irq();
    taste2.enable_irq();
    __enable_irq();
    meinLCD.clear();
    meinLCD.cursorpos(0x40);
    meinLCD.printf("Hallo Welt");
    
    while (true) {
        led = !led;
        zaehler++;
        meinLCD.cursorpos(0x00);
        meinLCD.printf("Zaehler = %d  ",zaehler);
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
#endif