/* mbed EventFramework Library 
 * Copyright (c) 2012 raulMrello
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef _LIST_H_
#define _LIST_H_

#include "../Node/Node.h"

/** List class
 *
 * List objects, can manage dual linked lists of nodes. They allow the insertion,
 * removal of nodes at different points of the list. It is a utiliy class for the
 * framework to manage Event and EventHandler queues.
 *
 */
class List{
    public:

    /** Creates a new List with a first node, in which is attached a new data
     *  item.
     *
     * @param item data object to attach to the first node.
     */
    List(void* item);

    ~List();

    /** Adds a new node with a new data item, after a specified node
     * already present in the list.
     *
     * @param node exisiting node in the list, previous to the new one to create.
     * @param item data reference to attach
     */
    void     AddAfter(Node* node, void* item);

    /** Adds a new node with a new data item, before a specified node
     * already present in the list.
     *
     * @param node exisiting node in the list, next to the new one to create.
     * @param item data object to attach
     * @returns 0 if the first node in the list is unchange, or a node reference
     * pointing to the new first node in the list.
     */
    Node*    AddBefore(Node* node, void* item);

    /** Removes a specified node from the list.
     *
     * @param node exisiting node in the list, to be removed.
     */
    void     Remove(Node* node);

    /** Removes a specified item in one or several nodes in the list.
     *
     * @param item attached data object reference to remove from the list.
     */
    void     RemoveItem(void* item);

    /** Removes all nodes of the list. Then frees memory allocated for the list.
     *
     */
    void     RemoveAll(void);

    /** Gets a reference to the first node in the list.
     *
     * @returns a reference to the first node in the list.
     */
    Node*    GetFirstNode(void);

    /** Sets the first node of the list with a node reference
     *
     * @param node node reference to set as first node of the list.
     */
    void     SetFirstNode(Node* node);
    private:
    Node* head;
};

#endif
