/* mbed EventFramework Library 
 * Copyright (c) 2012 raulMrello
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "List.h"

List::List(void* item){
    head = new Node(item);
}

List::~List(){
    RemoveAll();
    head = NULL;
}

Node* List::AddBefore(Node* node, void* item){
    Node* me = new Node(item);
    Node* prev = node->GetPrev();
    node->SetPrev(me);
    me->SetNext(node);
    if(prev){
        me->SetPrev(prev);
        prev->SetNext(me);
        return 0;
    }
    return me;
}

void List::AddAfter(Node* node, void* item){
    Node* me = new Node(item);
    Node* next = node->GetNext();
    node->SetNext(me);
    me->SetPrev(node);
    if(next){
        me->SetNext(next);
        next->SetPrev(me);    
    }
}
    
void List::Remove(Node* node){
    Node* prev = node->GetPrev();
    Node* next = node->GetNext();
    if(prev){
        prev->SetNext(next);
    }
    else{
        head = next;
    }
    if(next){
        next->SetPrev(prev);
    }
    delete node;
}
    
void List::RemoveItem(void* item){
    Node* cursor = head;
    while(cursor){
        void* data = cursor->GetData();
        if(data == item){
            Remove(cursor);
            return;            
        }
        cursor = cursor->GetNext();
    }
}
    
void List::RemoveAll(void){
    Node* cursor = head;
    while(cursor){
        Node* toRemove = cursor;
        cursor = cursor->GetNext();
        delete toRemove;
    }
}

Node* List::GetFirstNode(void){
    return head;
}

void List::SetFirstNode(Node* node){
    head = node;
}

     
