/* mbed EventFramework Library 
 * Copyright (c) 2012 raulMrello
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "Event.h"

Event::Event(uint16_t prio){
    this->prio = prio;
    base = NULL;
    data = NULL;
    hlist = NULL;
}

Event::~Event(void){
    prio = 0;
    data = NULL;
    base = NULL;
    if(hlist){
        delete hlist;
    }
}

void Event::SetData(void* data){
    this->data = data;
}

void Event::SetBase(Event* ev){
    base = ev;
}

void* Event::GetData(void){
    return data;
}

Event* Event::GetBase(void){
    return base;
}

List* Event::GetList(void){
    return hlist;
}

uint16_t Event::GetPrio(void){
    return prio;
}

void Event::Subscribe(EventHandler * hnd){
    // if EventHandler list is not created yet, then creates and add handler
    if(!hlist){
        hlist = new List(hnd);
        return;
    }
    // else insert the handler according with its priority
    Node* node = hlist->GetFirstNode();
    EventHandler* data = (EventHandler*)node->GetData();
    while(data->GetPrio() <= hnd->GetPrio()){
        Node* next = node->GetNext();
        if(!next){
            hlist->AddAfter(node, hnd);
            return;
        }
        data = (EventHandler*)next->GetData();
    }
    Node* newHead = hlist->AddBefore(node, hnd);
    if(newHead){
         hlist->SetFirstNode(newHead);
    }
}

void Event::Unsubscribe(EventHandler* hnd){
    hlist->RemoveItem(hnd);
}
