/* mbed EventFramework Library 
 * Copyright (c) 2012 raulMrello
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef _NODE_H_
#define _NODE_H_

#include "../Types/Types.h"

/** Node class
 *
 * Node objects are elements contained in a List, and linked to the previous and
 * next one. A Node can contain attached data as and object reference. It's a
 * utility class in the Framework to create Queues.
 *
 */
class Node{
    public:

    /** Creates a Node with a specified item attached.
     *
     * @param item data object reference to attach to this Node.
     */
    Node(void* item);
    Node();
    ~Node();

    /** Sets the reference to the next Node in the list.
     *
     * @param node node reference to the next node.
     */
    void   SetNext(Node* node);

    /** Sets the reference to the previous Node in the list.
     *
     * @param node node reference to the previous node.
     */
    void   SetPrev(Node* node);

    /** Gets the reference to the next Node in the list.
     *
     * @returns node reference to the next node.
     */
    Node*  GetNext(void);

    /** Gets the reference to the previous Node in the list.
     *
     * @returns node reference to the previous node.
     */
    Node*  GetPrev(void);

    /** Sets the attached data object item in the Node
     *
     * @param item data object reference to attach to this Node.
     */
    void   SetData(void* item);

    /** Gets the reference to the attached data object
     *
     * @returns attached data object reference.
     */
    void*  GetData(void);
    
    private:
    Node*  prev;
    Node*  next;
    void* data;    
};

#endif
