#include <mbed.h>
#include "MAX31855.h"
 
 MAX31855::MAX31855(SPI& _spi, PinName _ncs) : spi(_spi), ncs(_ncs)
{
    deselect();
}
 
float MAX31855::read_temp()
{
    short value = 0;
    float temp = 0;
     
    int16_t response = 0;
    uint8_t resp_byte = 0;
     
    select();
 
    resp_byte = spi.write(0);
    response |= resp_byte << 8;
    resp_byte = spi.write(0);
    response |= resp_byte << 0;

    deselect();
 
    if (response & 0x0001)
    {
        error("Error");
        return 2000.0;
    }
    
    response &= 0xfffc; // mask lower two bits
    temp = response / 16.0;

    return temp;
}
 
void MAX31855::select()
{
    ncs = 0;
}
 
void MAX31855::deselect()
{
    ncs = 1;
}