#include "mbed.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)

Serial pc(USBTX,USBRX);
 
int main(void) {
    
    MAG3110 mag(PTE0,PTE1,&pc);
    //mag.setCalibration(64140,64550,900,1145);
    
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED_RED);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);
    
    int x,y,z;
    int xnew = 0;
 
    while (true) {
        mag.getValues(&x, &y, &z);
        pc.printf("%d %d %d\n\r", x, y, z);
        
        float xnew = x;
        float ynew = y;
        float znew = z;
        
        rled = 1.0 - abs(float(x)/65535);
        gled = 1.0 - abs(float(y)/65535);
        bled = 1.0 - abs(float(z)/65535);
        

        //rled = 1.0 - abs(acc.getAccX());
        //gled = 1.0 - abs(acc.getAccY());
        //bled = 1.0 - abs(acc.getAccZ());
        //mag.getValues(&x,&y,&z);
        //pc.printf("%f\n\r",mag.getHeading());
        wait(0.1);
    }
}