// Code Modified with Bluetooth Structure Nidhin 2/6/17
///
#include "mbed.h"
#include "glc.h"
#include "i2c_dec.h"
//#include "ili9325.h"
//#include "lcd_base.h"
//#include "display_modules.h"
//#include "touch_modules.h"
#include "rtc.h"
#include "sdcard.h"
#include "eeprom_pgm.h"   // Nidhin 12/6/17
#include "main.h"
#include "struct.h" //Nidhin 31/5/2017
//#include "test_type.h" //Nidhin 31/5/2017

#define MAX_GLC_THRESHOLD       600
#define MIN_GLC_THRESHOLD       10
#define TIMEOUT_BG              20000  

void sample();
void Compute();
void i2c_spec();
Ticker flipper;
Ticker flipper1;
 unsigned char GLC_START = 0;
//osTimerDef (sample_data, sample);                      // define timers
//osTimerDef (Compute_GLC, Compute);  
DigitalIn test_strip(PTA12);

AnalogIn Ain(PTC1);//Electrode one
AnalogIn Ain2(PTE29); // Electrode two
AnalogOut DAC_signal(PTE30);
Serial gtc(USBTX, USBRX);
Timer timer_bg;


//signed char test_strip = 0;
static uint16_t mgdl = 0;
static uint16_t mgdll = 0;
uint16_t  daata1= 0;
uint16_t  data2 = 0;

static uint16_t  data1n= 0;
static uint16_t  data2n = 0;
uint16_t  datafinal1 = 0;
uint16_t  datafinal2 = 0;
//unsigned int data_diff = 0;
unsigned char err = 0;

uint32_t glcraw[2]; // Nidhin 31/5/2017
uint8_t chk_glc_data = 0;
uint16_t glc_testtype; // Nidhin 12/6/2017

void sample()
{
    data1n = Ain.read_u16();
    data2n = Ain2.read_u16();
    daata1 = beta*daata1+alpha*data1n;
    data2 = beta*data2+alpha*data2n;
      
    if( ((daata1-data2) >=(data2/10) && (daata1 > data2)) || ((data2-daata1) >=(data2/10) && (data2 > daata1)) )
    { 
        err = 1;       
    }
    else
    {
        err = 0;
        //gtc.printf("\n", data1n, data2n); only for testing added nidhin 5Jun17
    }
     
}



void Compute()
{
   flipper.detach();     // ticker for sampling is disabled
   datafinal1 = (uint16_t ) NUMB1*(data2*VREF/(TOTAL))-NUMB2;
   datafinal2 = (uint16_t ) NUMB1*(daata1*VREF/(TOTAL))-NUMB2;
   mgdl = (uint16_t) NUMB1*(((daata1+data2)/2)*VREF/(TOTAL))-NUMB2;  // Nidhin 5/6/17 mgdl = (uint16_t) NUMB1*(((daata1+data2)/2)*VREF/(TOTAL))-NUMB2;
   GLC_START = 0;
   flipper1.detach();// ticker for computation is disabled
}


void  glc(uint32_t pid)
{
   
    char t_s_d = 0;
    uint8_t err_no_teststip = 0; 
    bool timeout_flag = false; 
    
    i2c_spec();                                                                 // programming the i2c expander
    sd_open_GLCfilee(pid);                                                      // Opens GLC file in APPEND mode
   
    // Bluetooth Structure created globally
    BLEMsg_info *ptr_BLEMsg_info_glc, BLEMsg_info_glc;                          // A copy of master strcuture [ "BLEMsg_info" ] by name "BLEMsg_info_bp" is created
ptr_BLEMsg_info_glc = &BLEMsg_info_glc;                                         // *ptr_BLEMsg_info_bp is the pointer to local copy;
                                                                                // Cant declare this statement outside main. Causing conflicts

    // Declaration of Date Structure
    DateTime_info *ptr_DateTime_info_glc, DateTime_info_glc;                    // A copy of Master Structure "DateTime_info" created, 
    ptr_DateTime_info_glc = &DateTime_info_glc;                                 // Structure pointer points to that copy.
    
    // RTC operations
    time_t epoch_time_glc;                                                      //A copy of time_t by name  epoch_time_bp is created 
    epoch_time_glc = rtc_read();                                                // time is got from get epoch function.  
    
    struct tm * ptr_time_info_glc, time_info_glc;   // Sturucture copy of tm is created
    ptr_time_info_glc = localtime(&epoch_time_glc); // Structure accepts the time in local format from "time_t" type.
    /*  
    //BELOW LINE IS TO CHECK Date and TIME 
    gtc.printf("Time is - %d:%d:%d\n", (*ptr_time_info_glc).tm_hour, (*ptr_time_info_glc).tm_min, (*ptr_time_info_glc).tm_sec);
    gtc.printf("Date is - %d:%d:%d\n", (*ptr_time_info_glc).tm_mday, (*ptr_time_info_glc).tm_mon+1, (*ptr_time_info_glc).tm_year-100);
    */
    //Copying from one structure to the other using variables
    DateTime_info_glc.hour = (uint8_t)(*ptr_time_info_glc).tm_hour;
    DateTime_info_glc.mins = (uint8_t)(*ptr_time_info_glc).tm_min;
    DateTime_info_glc.sec =  (uint8_t)(*ptr_time_info_glc).tm_sec;
    
    DateTime_info_glc.date = (uint8_t) (*ptr_time_info_glc).tm_mday;
    DateTime_info_glc.month =(uint8_t)(*ptr_time_info_glc).tm_mon+1;
    DateTime_info_glc.year = (uint8_t)(*ptr_time_info_glc).tm_year-100;
    
    // Copying Time to Main structure
    BLEMsg_info_glc.date_time.hour = DateTime_info_glc.hour;
    BLEMsg_info_glc.date_time.mins = DateTime_info_glc.mins;
    BLEMsg_info_glc.date_time.sec = DateTime_info_glc.sec;
    
    BLEMsg_info_glc.date_time.date = DateTime_info_glc.date ;
    BLEMsg_info_glc.date_time.month = DateTime_info_glc.month ;
    BLEMsg_info_glc.date_time.year =  DateTime_info_glc.year ;
    
    /*
    //Checking if the structure has these values    
    gtc.printf("\nTime 2 is - %d:%d:%d\n", DateTime_info_glc.hour, DateTime_info_glc.mins, DateTime_info_glc.sec);
    gtc.printf("\nDate 2 is - %d:%d:%d\n",DateTime_info_glc.date, DateTime_info_glc.month, DateTime_info_glc.year);
    */
    
    //Loading values to of Test type
    test_type_info test_type_info_glc;  // copy of " test_type_info" created  
    test_type_info_glc = BG_Test;       // Loaded value 00 to the test type 
    
    BLEMsg_info_glc.test_type = test_type_info_glc;
    //Check if 01 is getting printed
    //gtc.printf("\nTest Type for BG is 01 = %d\n", test_type_info_glc);
    
    
    // Loading values of Length ,  PID, DID, sampling frequency, number of samples, calculated data.
    BLEMsg_info_glc.device_id = get_did();                   // Device ID fixed  // change on 11/8/17 nikita
    //BLEMsg_info_glc.patient_id = (uint16_t)pid;                               // Patient ID
    
    memcpy(BLEMsg_info_glc.patient_id,get_userpid(),sizeof(BLEMsg_info_glc.patient_id));
    
    BLEMsg_info_glc.sampling_freq = 0;              // sampling frrquency
    BLEMsg_info_glc.length = 30;                   //Total length of data in bytes  22 B+10752 B
    
    BLEMsg_info_glc.num_samples.num_sample_ecg_OTtyp =   2;
    BLEMsg_info_glc.num_samples.num_sample_ppg_dummy =  0;
       
     
            
    GLC_START = 1;
    // ble.baud(115200);
    if(GLC_START == 1)
    {
        timer_bg.reset();                           
        timer_bg.start();
        
        // send BG Insert Strip messages to mobile application
        poc2p0_send_device_msg_res(BG_INSERT_STRIP_RES);
        
        //glc_1();             // displaying messages to insert the test strip
        err = 0;
        data1n = 0;
        data2n = 0;
        daata1 = 0;
        data2 = 0;
        //sd_open_GLCfile(pid);      // opening the glc file Commented

        while((test_strip))
        { 
            if(timer_bg.read_ms() > TIMEOUT_BG)
            {
                timer_bg.stop();
                timeout_flag = true;
                break;
            }                                                                   
        }                                                                       
        gtc.printf("T_O: %d\n",timer_bg.read_ms());
        timer_bg.reset();
            
        if (!test_strip)                  // checks for the presence of test strip
        { 
            flipper.attach(&sample, 0.8);    
            t_s_d = 0;
            timer_bg.start();
            // send BG Drop Blood messages to mobile application
            poc2p0_send_device_msg_res(BG_DROP_BLOOD_RES);
    
            //glc_2();                  // displaying message to insert blood
    
            while((!t_s_d) && (!test_strip))
            {
                                
                if ((daata1 >= THRESHOLD) || (data2 >= THRESHOLD)) 
                { 
                        t_s_d = 1;
                        flipper1.attach(&Compute, 2.25);        //computing the glucose level
    
                        // send BG Test in progress messages to mobile application
                        poc2p0_send_device_msg_res(BG_TEST_IN_PROGRESS_RES);
    
                        //glc_3();
                        timer_bg.stop();
                }                                                               
                else if((timer_bg.read_ms() > TIMEOUT_BG))
                {
                    timer_bg.stop();
                    timeout_flag = true;
                    break;
                }                                                                
            }                                                                   //end of while(2)
            if(test_strip)     // added on 11/8/17 nikita
            {
                err_no_teststip = 1;
                timer_bg.stop();
                
            }   
            wait_ms(800);          
        }                                                                       //end of if(!test_strip)
    }                                                                           //end of if(GLC_start==1) 
    wait(2.25);
    gtc.printf("error = %d\n", err);   
    if ((err==0) && (err_no_teststip == 0) && ( mgdl < MAX_GLC_THRESHOLD) && ( mgdl > MIN_GLC_THRESHOLD) && (timeout_flag == false))
    {     
        // send Final BG result messages to mobile application
        poc2p0_send_device_test_result_res(BG_TEST_SUCCSS_RES, (uint32_t)mgdl);
        
        //glc_4(mgdl);
        gtc.printf("DATA1 is - %d\n", data1n); 
        gtc.printf("DATA2 is - %d\n", data2n);  
        gtc.printf("mgdl is - %d\n", mgdl);   
        
        glcraw[0] = (uint32_t)data1n;
        glcraw[1] = (uint32_t)data2n;
        
        sd_glcwrite(glcraw, pid);  //Writes the raw data into GLC file 
        
        //Results Stored to Bluetooth structure
        glc_testtype = eprom_read_16(20);  // Reads the test type (before meal = 0 / after meal = 1 OR Random = 2 from location 2 of the EEPROM) Nidhin 12/6/17
        BLEMsg_info_glc.cal_data.cal_sbp_dummy = (uint16_t) glc_testtype;  // Data stored into structure
        BLEMsg_info_glc.cal_data.cal_dbp_OTtyp = (uint16_t) mgdl;  //To be checked for reliable results           
        
        structure_file(ptr_BLEMsg_info_glc, pid);                                   // Copy the structure into the GLC file 
        glcfile_mainfile(pid);
        if(get_filecreated_status() == false)                                          //if file is in write mode 
        {   
            set_filecreated_status();                    
            increment_filepid (); 
        } 
        //screen_glc_2();   
    }
    else if(timeout_flag == false)                                                                           // added threshold to check value out of range   
    {  
        if(err_no_teststip == 1)                                               // added on  22/09/2017 nikita // to separately detect what is the parameter failed while testing 
        {
         // send BG remove test strip messages to mobile application
         poc2p0_send_device_msg_res(BG_TEST_STRIP_REMOVE_RES);
        
         //glc_error_test_strip_removed();
        }
         
        else if(err == 1 || mgdl > MAX_GLC_THRESHOLD || mgdl < MIN_GLC_THRESHOLD)
        {   
            // send BG Replace test strip messages to mobile application
            poc2p0_send_device_msg_res(BG_REPLACE_TEST_STRIP_RES);
            
            gtc.printf("replace teststip");
            //glc_error(); //disaply for showing error//10/7/17//nikita
        }
            
        delete_subfiles(pid); // added on 11/8/17 nikita
        //screen_glc_2();
    } 
    else
    {
        poc2p0_send_device_msg_res(BG_TIMEOUT_RES);
    }  
    
}