#ifndef STRUCT_H_
#define STRUCT_H_

#include "bp.h"
#include "glc.h"
#include "ecg_dec.h"
//#include "test_type.h"


typedef struct __attribute__((__packed__))
{
    uint8_t               date;
    uint8_t               month;
    uint8_t               year;
    uint8_t               hour;
    uint8_t               mins;
    uint8_t               sec;
}DateTime_info;

typedef struct __attribute__((__packed__))
{
    uint16_t             num_sample_ppg_dummy;
    uint16_t             num_sample_ecg_OTtyp;
}NumSamples_info;


typedef struct __attribute__((__packed__))
{
    uint16_t             cal_sbp_dummy;
    uint16_t             cal_dbp_OTtyp;
}CalData_info;

/*typedef enum 
{ 
     ACK = (uint8_t)0x00,
    start_of_file,
    end_of_file,
    data_trfr,
    NACK=0xff,
}bt_st;*/

typedef enum
{ 
    BP_Test =   (uint8_t )0x00,   // removed Semi Colon and replaced with comma
    BG_Test ,
    ECG_Test, 
}test_type_info;


typedef struct __attribute__((__packed__))
{
  uint32_t                  length;
  uint8_t                   device_id;
  char                      patient_id[10];
  DateTime_info             date_time;
  test_type_info            test_type;
  uint16_t                  sampling_freq;
  NumSamples_info           num_samples;
  CalData_info              cal_data;
}BLEMsg_info;

/*typedef enum 
{ 
     sos= (uint8_t)0xc0,
     eos= (uint8_t)0xc0,
}file_st;*/



typedef struct __attribute__((__packed__))
{

uint8_t start_of_string;
 uint32_t length_file;
  uint8_t proto;
 BLEMsg_info  bt_msg;
 uint8_t end_of_string;
 uint8_t chk_sum;

}Point;


uint8_t bt_send( uint8_t send_tx);
uint8_t bt_receive(uint8_t send_rx);
void send_structure();
void send_initial_string();
void send_last_string();
void send_data_str1();
void send_data_str2(uint8_t check_sum);
//uint8_t checksum(uint32_t  *v1);
uint8_t checksum_init();;
uint8_t checksum_last();
//uint8_t checksum_struct();

uint8_t checksum_struct(const uint8_t data[], uint16_t numBytes) ;
uint8_t checksum_rawdata(const uint8_t data[], uint32_t numBytes) ;

uint8_t poc2p0_bt_receive (uint8_t curr_touch_state);
char* get_userpid(void);
#endif
