#include "mbed.h"
#include "sdcard.h"
#include "struct.h"
#include "eeprom_pgm.h"
#include "main.h"
 
#define ACK 0x00                                /// changed //16/06 #define all the values removing structure 
#define START_OF_FILE       0x01
#define END_OF_FILE         0x02
#define DATA_TRFR           0x03
#define NACK                0xFF
#define SOS                 0xc0
#define EOS                 0xc0
#define NO_OF_SAMPLES       600                   //changed the buffer size from 150- 22/7/17- suhasini
#define CHKSUM              0x80 
#define STRUCTURE_LENGTH    26
#define POC2P0_BT_RX_MSG_LEN 0x05U

typedef struct __attribute__((__packed__))
{
    uint8_t     sos;
    uint8_t     cmd;
    uint8_t     length;
    uint8_t     eos;
    uint8_t     chksum;

}poc2p0_bluetooth_msg_request;

poc2p0_bluetooth_msg_request poc2p0_bt_msg_req = {0};
//static void poc2p0_ascii_to_hex(const uint8_t input_buffer[], uint8_t len);
static void poc2p0_ascii_to_hex(const uint8_t input_buf[], uint8_t len_ip_buf, uint8_t output_buf[], uint8_t len_op_buf);
static void hex_to_char(const char input_buffer[]);


BLEMsg_info *bt_file;
Point *myBleMsg;
 
Serial mc(USBTX,USBRX);                  // serial terminal
Serial blue(PTC4,PTC3);                 // communicating bluetooth through serial 
                 
static uint32_t total_samples=0;        // variable to hold total number of samples
Point b;                                // structure copy
BLEMsg_info bt_file1;                   // structure copy
static uint32_t total_file_size=0;      // to determine the size of the file 
static uint32_t total_file_size_sent=0; 
static uint32_t file_start=0;           // variable for 'for loop'
//static uint32_t j=0;
uint8_t count_send=0; 
static uint32_t file_pointer_position=0;
static uint32_t counter=0;
static  uint32_t v1[NO_OF_SAMPLES];  
uint8_t file=0;
static uint32_t bt_pid = 0; 
static char user_pid[10] = {0}; 


 
uint8_t bt_send(uint8_t state_tx)
{
    mc.format();   
    mc.baud(115200);
    blue.baud(115200);                  // baud rate of bluetooth
    bt_file=&bt_file1;                      
    myBleMsg=&b; 
    int8_t check_sum=0;
    uint8_t state_rx =0;
 
  switch(state_tx)
          {
 
       case 1:    
                  state_tx =0; 
                  counter=0;
                  total_file_size_sent=0; 
                  file_start=0;           
                  count_send=0;  total_samples=0;  
                  file_pointer_position=0;
                  bt_pid = get_btpid()+1;                           //added on 22/09/2017 nikita
                 //mc.printf("bt_pid = %d\n",get_btpid());
                if(get_filepid()>=bt_pid)                           //check for pid and bluetooth pid by reading from file// modified to send till the current pid, 3rd nov// 
                {
                    send_initial_string(); 
                    blue.printf("\n"); 
                    file=sd_open_read(bt_pid);                         // open the file for reading
                    total_file_size=file_size();                           // determined the file size 
                    state_rx = 1;  
                }
                         
                else 
                {
                    state_rx =0;                                        //no files to send
                    //mc.printf("no file to send\n");  
                }       
                break;
                         
                   
       case 2:   total_samples=0; 
                 //file=sd_open_read(get_btpid());  
                // total_file_size=file_size() ;                           // determined the file size 
                 sd_read1(bt_file1);                                    // read the sd card file
                 //mc.printf("sd file opened to read data in it\n");
                 myBleMsg->bt_msg=bt_file1;                              //copy the contents to the structure
                 send_structure();                                       // send the structure string
                 blue.printf("\n");   
                 //mc.printf("sent initial string\n");                    
                 total_samples= myBleMsg->bt_msg.num_samples.num_sample_ppg_dummy+myBleMsg->bt_msg.num_samples.num_sample_ecg_OTtyp;
                 state_tx =0;
                 state_rx =2;
                 count_send=0;
                 total_file_size_sent=file_size1();
                 break;                 
 
 
        case 3:    
                counter=0;
                if(count_send<(total_samples/NO_OF_SAMPLES))
                {
                    sd_read(v1,NO_OF_SAMPLES);      
                    counter=NO_OF_SAMPLES;               //read 1500 samples
                    send_data_str1(); 
                    for(file_start=0;file_start<(NO_OF_SAMPLES);file_start++)
                    {     
                       
                        blue.printf("%08x", v1[file_start]);
                           
                    }
                          
                    check_sum=checksum_rawdata((uint8_t *)v1,counter);               // calculating checksum            // calculating checksum
                    state_tx =0;
                    state_rx =3;
                    send_data_str2(check_sum);            // send the remaining part of the string
                  
                }
               
                else 
                {
                    for(uint16_t l=0;l<NO_OF_SAMPLES;l++)
                    {    
                        v1[l]=NULL;
                    }
                            counter=(total_samples-( NO_OF_SAMPLES*count_send));
                            send_data_str1();
                            sd_read(v1,(total_samples-( NO_OF_SAMPLES*count_send)));
                       
                        for(file_start=0;file_start<(total_samples-( NO_OF_SAMPLES*count_send));file_start++)
                          {     
                             blue.printf("%08x", v1[file_start]);
                            
                           }
                                                                   
                          state_tx=0;
                          state_rx=4;
                          check_sum=checksum_rawdata((uint8_t *)v1,counter);               // calculating checksum
                          send_data_str2(check_sum);
                    }   
                     
                        total_file_size_sent=file_size1();
                        blue.printf("\n");  
                  break;        
               
         
        case 4:  // total_file_size_sent=file_size1();
                 if(total_file_size_sent==total_file_size)          // if the total file size is same as total file size
                     {                                         // then there is no more data to send in that particular file
                    
                        state_rx=5;
                        send_last_string();
                        blue.printf("\n"); 
                  
                     }
                else   
                       {
                        
                         total_samples=0;   
                         sd_read1(bt_file1);               // read the sd card file
                       //  mc.printf("sd file opened to read data in it\n");
                         myBleMsg->bt_msg=bt_file1;         //copy the contents to the structure
                         send_structure();                                // send the initial string
                         blue.printf("\n");   
                       //  mc.printf("sent initial string\n");                    
                         total_samples= myBleMsg->bt_msg.num_samples.num_sample_ppg_dummy+myBleMsg->bt_msg.num_samples.num_sample_ecg_OTtyp;
                         state_tx =0;
                         state_rx =2;
                         count_send=0;
                         total_file_size_sent=file_size1();
                                
                        }   
                       
   
 
 
         }
 
   return state_rx;     
        
  }           
 
 
 
 
uint8_t bt_receive (uint8_t state_rx)
{
       
unsigned char state_tx =1;                                                      //state for transmitting 
uint8_t string_length_rx=0;
char ack_rx[2];                                                                 // varibale to receive ack from the bluetooth 
char chksum_rx[3]; 
char btdata_received[17];
 
 
while (blue.readable()!= NULL)                                                    // reading string from bluetooth app
   {
       blue.scanf("%17s", btdata_received);
       //mc.printf("%s\r\n", btdata_received);

    }                                 
   
        string_length_rx = strlen(btdata_received);                                // storing the length of the string received
        memcpy(ack_rx, btdata_received+1, 2);                                       // reading the ack received
        memcpy(chksum_rx, btdata_received+(string_length_rx-2), 3);                  // reading the checksum received
        //mc.printf("%s\r\n",ack_rx);
        //mc.printf("%s\r\n",chksum_rx);
    
     switch(state_rx)
         {
                
          case 1:                                                                   // wait for the ack
                      state_rx=0;
                      myBleMsg->proto=ACK;
                 if ((strcmp(ack_rx ,"00") == NULL ) && (strcmp(chksum_rx ,"80" ) == NULL))                             // check for ack and checksum
               
                     {
                       
                       state_tx=2;
                      }
                    
                    else 
                    
                      { 
                       
                        state_tx=1;
                        sd_close();
                      }
                   break;                 
 
         case 2:      state_rx =0;                        //wait for the ack
                  
                   if ((strcmp(ack_rx ,"00") == NULL ) && (strcmp(chksum_rx ,"80" ) == NULL))  
                        {
                
                          state_tx=3;
                          file_pointer_position=total_file_size_sent;
                        }
                    
                    else 
                    
                        { 
                      
                        state_tx=2;
                        setpos1(file_pointer_position);
                        //sd_close();                                                     //file closed which was opened earlier because it opens again in bt_send case 1
             
                        }
                    //blue.scanf("%02x%02x%08x%02x",&sos_rx,&ack_rx,&eos_rx,&chksum_rx);
                    break;
 
                
     case 3:       
                   state_rx =0;
                if ((strcmp(ack_rx ,"00") == NULL ) && (strcmp(chksum_rx ,"80" ) == NULL))  
                      {
                     
                         state_tx=3;
                         count_send=count_send+1;
                         file_pointer_position=total_file_size_sent;
                      }
                    
                  else 
                    
                      { 
                       
                        state_tx=3;
                        file_start=file_start- NO_OF_SAMPLES;
                        setpos1(file_pointer_position);
                      }
               
                   break;    
                                            
     case 4:       
                   state_rx =0;
               if ((strcmp(ack_rx ,"00") == NULL ) && (strcmp(chksum_rx ,"80" ) == NULL))  
                      {
                         state_tx=4;
                         count_send=count_send+1;
                         file_pointer_position=total_file_size_sent;
                      }
                    
                  else 
                    
                      { 
                       
                        state_tx=3;
                        file_start=file_start- NO_OF_SAMPLES;
                        setpos1(file_pointer_position);
                      } 
                   break;                
                 
 
      case 5:      state_rx = 0;
               if ((strcmp(ack_rx ,"00") == NULL ) && (strcmp(chksum_rx ,"80" ) == NULL))  
                {
                    sd_close();
                    increment_btpid();                // increment the bluetooth pid and write in the file
                    //mc.printf("next file");   
                    //mc.printf("bt_pid = %d\n",get_btpid());    
                    state_tx=1;
                          
                }
                       
                else 
                {
                    state_tx = 4;   
                       
                }           
                break;
 
  }
 
   return state_tx;          
  }           
   
 
 
 
 
 
             
void send_structure()                                 // function to send the structure to bluetooth
{
    myBleMsg->start_of_string=SOS;
    myBleMsg->length_file = STRUCTURE_LENGTH;
    myBleMsg->proto=DATA_TRFR;                      // data transfer mode
    blue.printf("%02x",myBleMsg->start_of_string); 
    blue.printf("%02x",myBleMsg->proto);
    blue.printf("%08x",myBleMsg->length_file);      //changed the sequence 
    blue.printf("%08x",myBleMsg->bt_msg.length); 
    blue.printf("%02x",myBleMsg->bt_msg.device_id); 
    //blue.printf("%08x",myBleMsg->bt_msg.patient_id);                            //changed to 10 
    for (uint8_t i = 0; i < sizeof(myBleMsg->bt_msg.patient_id); i++)
    {
        blue.printf("%02x",myBleMsg->bt_msg.patient_id[i]);
        mc.printf("%02x",myBleMsg->bt_msg.patient_id[i]);
    }
    blue.printf("%02x",myBleMsg->bt_msg.date_time.date);     
    blue.printf("%02x",myBleMsg->bt_msg.date_time.month);  
    blue.printf("%02x",myBleMsg->bt_msg.date_time.year);  
    blue.printf("%02x",myBleMsg->bt_msg.date_time.hour);      
    blue.printf("%02x",myBleMsg->bt_msg.date_time.mins);  
    blue.printf("%02x",myBleMsg->bt_msg.date_time.sec);  
    blue.printf("%02x",myBleMsg->bt_msg.test_type);   
    blue.printf("%04x",myBleMsg->bt_msg.sampling_freq); 
    blue.printf("%04x",myBleMsg->bt_msg.num_samples. num_sample_ppg_dummy); 
    blue.printf("%04x",myBleMsg->bt_msg.num_samples.num_sample_ecg_OTtyp); 
    blue.printf("%04x",myBleMsg->bt_msg.cal_data.cal_sbp_dummy);   
    blue.printf("%04x",myBleMsg->bt_msg.cal_data.cal_dbp_OTtyp); 
    myBleMsg->end_of_string=EOS;  
    myBleMsg->chk_sum = checksum_struct((uint8_t *)myBleMsg, sizeof(Point));
    blue.printf("%02x",myBleMsg->end_of_string);
    blue.printf("%02x",myBleMsg->chk_sum);
               
    
    }
    
void send_initial_string()                // function to send the initial string at the start f communication to bluetooth
{              
 
    uint8_t sum_init=0  ;               
    myBleMsg->start_of_string=SOS;
    myBleMsg->length_file=0;
    myBleMsg->proto=START_OF_FILE;
    sum_init=checksum_init();
    myBleMsg->chk_sum=sum_init;
    blue.printf("%02x",myBleMsg->start_of_string);
    blue.printf("%02x",myBleMsg->proto); 
    blue.printf("%08x",myBleMsg->length_file);     // chnged
    myBleMsg->end_of_string=EOS;  
    blue.printf("%02x",myBleMsg->end_of_string);
    blue.printf("%02x",myBleMsg->chk_sum);
    
    }
  
   
uint8_t checksum_init()          // function to calculate the checksum for the initial string
 {
  
  uint32_t sum = 0;
  uint8_t chksum_init = 0;
  sum=SOS+EOS+START_OF_FILE; 
  chksum_init = sum & 0x000000FF;
  return chksum_init;
  }
 
uint8_t checksum_last()        // function to calculate the checksum for the last string
 {
  
  uint32_t sum = 0;
  uint8_t chksum_last = 0;
  sum=SOS+EOS+END_OF_FILE; // changed //16/06 #define all the values removing structure 
  chksum_last=sum & 0x000000FF;
  return chksum_last;
  }    
    
void send_last_string()                 // function to send the last string to the bluetooth // which determines the end of file
{
    uint8_t sum_last=0;
    myBleMsg->start_of_string = SOS;
    myBleMsg->length_file = 0;
    myBleMsg->proto=END_OF_FILE;
    sum_last=checksum_last();
    myBleMsg->chk_sum=sum_last;
    blue.printf("%02x",myBleMsg->start_of_string);
    blue.printf("%02x",myBleMsg->proto); 
    blue.printf("%08x",myBleMsg->length_file);     // chnged
    myBleMsg->end_of_string=EOS;  
    blue.printf("%02x",myBleMsg->end_of_string);
    blue.printf("%02x",myBleMsg->chk_sum);
                
}
       
void send_data_str1()       // function to send a part of the structure // after this raw data is sent//
{
    myBleMsg->start_of_string=SOS;
    myBleMsg->length_file=(counter*4);
    myBleMsg->proto=DATA_TRFR;
    blue.printf("%02x",myBleMsg->start_of_string); 
    blue.printf("%02x",myBleMsg->proto);                   // chnaged
    blue.printf("%08x",myBleMsg->length_file);
 
}
    
    
    
void send_data_str2(uint8_t check_sum)          // after raw data// this last part of structure is sent
{          
    myBleMsg->chk_sum=check_sum;
    myBleMsg->end_of_string=EOS;  
    blue.printf("%02x",myBleMsg->end_of_string);
    blue.printf("%02x",myBleMsg->chk_sum);
    
}
    
 
uint8_t checksum_struct(const uint8_t data[], uint16_t numBytes)         // calculating checksum for 
{
    uint32_t chksum_struct = 0;
    uint16_t index = 0;
    
    for (index=0U; index < (numBytes-1); index++)
    {
          chksum_struct += data[index];  
          //mc.printf("data=%02x\n",data[index]);
        
    }
  // blue.printf("%08x\n",chksum_struct);  
  return chksum_struct;
}
 
 
uint8_t checksum_rawdata(const uint8_t data[], uint32_t numBytes)          // this function to calculate the checksum for the raw data
{
 
    uint32_t sum=0;
    uint8_t  chksum_datatrfr=0;
    uint32_t index = 0;
    uint32_t index1 = 0;
    sum += SOS;
    sum += DATA_TRFR;  
    index1=(numBytes*4);
    sum +=(index1>>(8*0))&0xFF;
    sum +=(index1>>(8*1))&0xFF; 
 
    for (index=0U; index<(numBytes*4); index++)
    { 
    sum += data[index];
    }
 
    sum+=EOS;
 
    chksum_datatrfr = sum & 0x000000FF;
 //mc.printf("chksum_datatrfr=%02x\n",chksum_datatrfr);
    return chksum_datatrfr;
}
 

// this function checks bluetooth command and if any byte received it process
// that command and assigned and return touch state
uint8_t poc2p0_bt_receive (uint8_t curr_touch_state)
{ 
    uint8_t bt_rx_buffer[31] = {0};
    uint8_t usr_pid_hex[15] = {0};
    uint8_t cal_chksum = 0xFFu;
    uint8_t touch_state = 0x00u;
    char user_pid_char[20];
    //const char *ptr = user_pid_char;
    //uint8_t ch = 0 ;
    //uint8_t n = 0;
    //uint8_t buff_index = 0;
    uint8_t usr_pid_chksum = 0;
        
    //if (mc.readable()!= NULL)                                                 // reading string from putty
    if (blue.readable()!= NULL)                                                 // reading string from bluetooth
    {
        //wait_ms(50);                                                          //commented on 16-NOV rashmi
        blue.scanf("%31s",bt_rx_buffer);
        //mc.scanf("%31s",bt_rx_buffer);
              
        mc.printf("\n\r Command =");
        mc.printf("%s\r\n", bt_rx_buffer); 
        
        //poc2p0_ascii_to_hex ((uint8_t *)bt_rx_buffer, sizeof(bt_rx_buffer));
        poc2p0_ascii_to_hex((uint8_t *)bt_rx_buffer, sizeof(bt_rx_buffer), (uint8_t *)&poc2p0_bt_msg_req, sizeof(poc2p0_bt_msg_req));
          
    }  
    
    if(poc2p0_bt_msg_req.cmd == TEST_SCREEN_REQ)
    { 
        memcpy(user_pid_char,bt_rx_buffer+6,20); 
        hex_to_char((const char *)user_pid_char);
        mc.printf("User pid = %s\n",user_pid_char);
        /*while ( *ptr )
        {
            if ( sscanf(ptr, "%2x%n", &ch, &n) != 1 )                             //ch -> holds data ; n-> no. of characters read
            {
                break;
            }
            ptr += n;
            user_pid[buff_index++] = char(ch);
        }
        mc.printf("User pid after copy = %s\n",user_pid);
        */
        
        poc2p0_ascii_to_hex((uint8_t *)bt_rx_buffer, sizeof(bt_rx_buffer), (uint8_t *)usr_pid_hex, sizeof(usr_pid_hex));
        usr_pid_chksum = usr_pid_hex[14];
        mc.printf("usr_pid_chksumksum = %02x\n",usr_pid_chksum);
        cal_chksum = checksum_struct((uint8_t *)usr_pid_hex+1, (sizeof(usr_pid_hex)-1));
          
    }
    else
    {
       cal_chksum = checksum_struct((uint8_t *)&poc2p0_bt_msg_req.cmd, (sizeof(poc2p0_bt_msg_req)-1));
    }
    
    //if ((cal_chksum == poc2p0_bt_msg_req.chksum) || (cal_chksum == usr_pid_chksum))
    //{
        switch (poc2p0_bt_msg_req.cmd)
        {
        case STRT_BP_TEST_REQ:
            mc.printf("\n\r cal_chksum = %2x\n", cal_chksum); 
            touch_state = TOUCH_STATE_BP_TEST_SCREEN;
            break;

        case STRT_BG_FBS_TEST_REQ:
            mc.printf("\n\r cal_chksum = %2x\n", cal_chksum); 
            eprom_write_16(20,0);                                               //added on 14-Nov by rashmi
            touch_state = TOUCH_STATE_BG_TEST_SCREEN;
            break;

        case STRT_BG_PP_TEST_REQ:
            mc.printf("\n\r cal_chksum = %2x\n", cal_chksum); 
            eprom_write_16(20,1);                                               //added on 14-Nov by rashmi 
            touch_state = TOUCH_STATE_BG_TEST_SCREEN;
            break;

        case STRT_BG_RAN_TEST_REQ:
            mc.printf("\n\r cal_chksum = %2x\n", cal_chksum); 
            eprom_write_16(20,2);                                               //added on 14-Nov by rashmi
            touch_state = TOUCH_STATE_BG_TEST_SCREEN;
            break;

        case STRT_ECG_TEST_REQ:
            mc.printf("\n\r cal_chksum = %2x\n", cal_chksum); 
            touch_state = TOUCH_STATE_ECG_SCREEN;
            break;

        case DATA_SYNC_REQ:
            //poc2p0_send_device_msg_res(DATA_SYNC_MSG_ACCEPTED_RES);
            mc.printf("\n\r cal_chksum = %2x\n", cal_chksum); 
            touch_state = 12 ;                                                  //TOUCH_STATE_DATA_SYNC_SCREEN
            break;

        case HEARTBEAT_REQ:
            mc.printf("\n\r cal_chksum = %2x\n", cal_chksum); 
            mc.printf("curr_touch_state: %2x\n",curr_touch_state);
            if ((curr_touch_state == TOUCH_STATE_HOME_SCREEN)||(curr_touch_state == TOUCH_STATE_TEST_SCREEN))
            {
                poc2p0_send_device_heartbeat_msg_res(curr_touch_state);
            }
            break;

        case HOME_SCREEN_REQ:
            mc.printf("\n\r cal_chksum = %2x\n", cal_chksum); 
            touch_state = TOUCH_STATE_HOME_SCREEN;
            poc2p0_send_device_msg_res(HOME_SCREEN_MSG_ACCEPTED_RES);
            break;

        case TEST_SCREEN_REQ:
            mc.printf("\n\r cal_chksum = %2x\n", cal_chksum); 
            touch_state = TOUCH_STATE_TEST_SCREEN;
            poc2p0_send_device_msg_res(TEST_SCREEN_MSG_ACCEPTED_RES);
            break;
        
        case SD_READ_REQ:
            mc.printf("\n\r cal_chksum = %2x\n", cal_chksum); 
            touch_state = 15;           
            break;    
            

        default:
            break;
        }
    //}
  
     memset((void *)bt_rx_buffer,0x00,sizeof(bt_rx_buffer));
     memset((void *)&poc2p0_bt_msg_req,0x00,sizeof(poc2p0_bt_msg_req));              //to clear the structure else the command would be in the loop
     return touch_state;
}

// this function use to convert data from ascii to hex
/*static void poc2p0_ascii_to_hex(const uint8_t input_buf[], uint8_t len)
{
    uint8_t i = 0;
    uint8_t j = 0;
    uint8_t temp_ms_nibble = 0;
    uint8_t temp_ls_nibble = 0;
    uint8_t temp_buf[len];

    for (i = 0,j = 0; i < len; i+=2, ++j)
    {
        temp_ms_nibble = input_buf[i] > '9' ? (input_buf[i]|32) - 'a' + 10 : input_buf[i] - '0';      
        temp_ls_nibble = input_buf[i+1] > '9' ? (input_buf[i+1]|32) - 'a' + 10 : input_buf[i+1] - '0';
        temp_buf[j] = (temp_ms_nibble << 4) | temp_ls_nibble;
        mc.printf("\n\r msg_SOS = %2x", temp_buf[j]);
    }
    
    memcpy(&poc2p0_bt_msg_req, &temp_buf, sizeof(poc2p0_bt_msg_req));
    
    return;
} */
  

char* get_userpid(void)
{
    return user_pid;
}




static void poc2p0_ascii_to_hex(const uint8_t input_buf[], uint8_t len_ip_buf, uint8_t output_buf[], uint8_t len_op_buf)
{
    uint8_t i = 0;
    uint8_t j = 0;
    uint8_t temp_ms_nibble = 0;
    uint8_t temp_ls_nibble = 0;
    uint8_t temp_buf[len_ip_buf];

    for (i = 0,j = 0; i < len_ip_buf; i+=2, ++j)
    {
        temp_ms_nibble = input_buf[i] > '9' ? (input_buf[i]|32) - 'a' + 10 : input_buf[i] - '0';      
        temp_ls_nibble = input_buf[i+1] > '9' ? (input_buf[i+1]|32) - 'a' + 10 : input_buf[i+1] - '0';
        temp_buf[j] = (temp_ms_nibble << 4) | temp_ls_nibble;
        //mc.printf("\n\r msg_SOS = %2x", temp_buf[j]);
    }
    
    memcpy(output_buf, &temp_buf, len_op_buf);
    
    return;
} 


static void hex_to_char(const char input_buffer[])
{
    const char *ptr = input_buffer;
    uint8_t ch = 0 ;
    uint8_t n = 0;
    uint8_t buff_index = 0;
    
    while ( *ptr )
    {
            if ( sscanf(ptr, "%2x%n", &ch, &n) != 1 )                           //ch -> holds data ; n-> no. of characters read
            {                                                                   //sscanf returns 1 when the format matches,there is no data
                break;
            }
            ptr += n;
            user_pid[buff_index++] = char(ch);
    }
    mc.printf("User pid after copy = %s\n",user_pid);
            
}







   

