#ifndef MAIN_H_
#define MAIN_H_

#define TIMER_ENABLE_DEBUG_MODE             600000              //added on 22/09/2017 nikita
#define DATETIME_SIZE                       6

// sentinel for bluetooth communication protocol for POC2P0
#define SOS_EOS                             0xC0u

// message request id from mobile application for POC2P0
#define STRT_BP_TEST_REQ                    0x10u

#define STRT_BG_FBS_TEST_REQ                0x20u
#define STRT_BG_PP_TEST_REQ                 0x21u
#define STRT_BG_RAN_TEST_REQ                0x22u

#define STRT_ECG_TEST_REQ                   0x30u

#define DATA_SYNC_REQ                       0x70u
#define HEARTBEAT_REQ                       0x71u
#define HOME_SCREEN_REQ                     0x72u
#define TEST_SCREEN_REQ                     0x73u


#define SD_READ_REQ                         0X78u

// message response id from device for POC2P0
#define BP_TEST_IN_PROGRESS_RES             0x16u
#define BP_TEST_SUCCSS_RES                  0x1Au
#define BP_LEADOFF_FINGER_IMPROPER_RES      0x1Eu
#define BP_RESULT_IMPROPER_RES              0x1Fu

#define BG_TEST_IN_PROGRESS_RES             0x26u
#define BG_TEST_STRIP_REMOVE_RES            0x27u
#define BG_INSERT_STRIP_RES                 0x28u
#define BG_DROP_BLOOD_RES                   0x29u
#define BG_TEST_SUCCSS_RES                  0x2Au
#define BG_REPLACE_TEST_STRIP_RES           0x2Eu
#define BG_RESULT_IMPROPER_RES              0x2Fu
#define BG_TIMEOUT_RES                      0X2Du

#define ECG_TEST_IN_PROGRESS_RES            0x36u
#define ECG_TEST_SUCCSS_RES                 0x3Au
#define ECG_LEADOFF_RES                     0x3Eu
#define ECG_RESULT_IMPROPER_RES             0x3Fu

#define DATA_SYNC_MSG_ACCEPTED_RES          0x79u
#define HEARTBEAT_SYNC_MSG_ACCEPTED_RES     0x7Au
#define HOME_SCREEN_MSG_ACCEPTED_RES        0x7Bu
#define TEST_SCREEN_MSG_ACCEPTED_RES        0x7Cu

#define MSG_REJECTED_RES                    0x7Fu

// touch states currently used in POC1P0 and now used for POC2P0 receive from mobile application
#define TOUCH_STATE_HOME_SCREEN             0x01u
#define TOUCH_STATE_TEST_SCREEN             0x03u   

#define TOUCH_STATE_BP_TEST_SCREEN          0x09u
#define TOUCH_STATE_BG_TEST_SCREEN          0x07u
#define TOUCH_STATE_ECG_SCREEN              0x08u

#define TOUCH_STATE_DATA_SYNC_SCREEN        0x02u

/**********************************************************************************
****************************** Global Function ************************************
**********************************************************************************/


void poc2p0_send_device_msg_res(uint8_t);
void poc2p0_send_device_heartbeat_msg_res(uint8_t);
void poc2p0_send_device_test_result_res(uint8_t, uint32_t);

bool get_filecreated_status(void);                                              //get status of file created
void set_filecreated_status(void);                                              //set file created
void clear_filecreated_status(void);                                            //clear file created
void increment_filepid (void);
void increment_btpid (void);
uint32_t get_btpid(void);
void store_btpid(uint32_t bt_pid);
uint32_t get_filepid(void);
void store_filepid(uint32_t pid);
bool read_debug_status();
uint32_t get_timer_debug();

uint8_t get_did(void);                                                          //get device ID


#endif

