#include "mbed.h"
//#include "display_modules.h"
//#include "touch_modules.h"
#include "ecg_dec.h"
//#include "touch_modules.h"
#include "glc.h"
#include "bp.h"
#include "sdcard.h"
#include "eeprom_pgm.h"
#include "struct.h"
#include "battery.h" 
#include "rtc.h"
#include "main.h"
#include "SDFileSystem.h"

#define TIMER_RXACK_BTCONNECTION                10000
#define BATTERY_TIMER_VALUE                     600000
#define SERIAL_BAUD_RATE                        115200
#define BATTERY_SCREEN_NO_CHARGE_CONDITION      3
#define TIMER_ENTER_DEBUG_MODE                  10000
#define HEARTBEAT_DATA_LEN                      0x13u                           //changed from 0D to 13
#define DEVICE_RESULT_DATA_LEN                  0x04u
#define ZERO_DATA_LEN                           0x00u


typedef enum
{
    HOME_SCREEN = 0x01U,
    TEST_SCREEN
}DEVICE_STATE;
typedef enum
{
    GET_TOUCH_DISP_STATE = 0x00U,
    BT_TX_STATE,
    BT_RX_STATE

}DEVICE_MAIN_STATE;

// this helps to respond various status during test cycle, error condition and simple ack or nack
typedef struct __attribute__((__packed__))
{
    uint8_t     sos;
    uint8_t     cmd;                    // this contains error response
    uint8_t     length;
    uint8_t     eos;
    uint8_t     chksum;

}poc2p0_device_msg_response;

typedef struct __attribute__((__packed__))
{
    uint8_t     sos;
    uint8_t     cmd;
    uint8_t     length;
    uint32_t    test_result;
    uint8_t     eos;
    uint8_t     chksum;

}poc2p0_device_tst_result_response;

// this will be used for responding heart beat message
typedef struct __attribute__((__packed__))
{
    uint8_t                 sos;
    uint8_t                 cmd;                    // this contains error response
    uint8_t                 length;
    uint8_t                 did;
    char                    pid[10];
    //uint32_t              pid;
    DateTime_info           date_time;
    uint8_t                 device_state;          //changed POC2P0_DEVICE_STATE to uint8_t
    uint8_t                 battery_status;
    uint8_t                 eos;
    uint8_t                 chksum;

}poc2p0_device_heartbeat_response;

SDFileSystem sd(PTE1, PTE3, PTE2, PTE4, "sd");
Serial gc(USBTX, USBRX);
DigitalIn q1(PTB11);
DigitalIn q(PTC5);
DigitalIn q3(PTC12);
DigitalIn BT(PTA5);   
Serial blue1(PTC4,PTC3); 
 
uint32_t get_timer_bluetooth();
static void battery_status_monitoring();                                     //bluetooth status pin
uint8_t touch(uint8_t state);                                               // touch state
uint8_t display(uint8_t state1);                                            //  display state
static void ecg_bp_countdown(void);
static void read_device_id(void);
void sd_card_status(void);

static uint8_t nstate=0;
static uint8_t nstate1=0;                                                  
static bool file_created_status = false;                                  //initialise file created to 0
static uint32_t filepid_btpid[2] = {};
Timer timer_bt;                                                         // timer for bluetooth 
Timer timer_battery;                                                    // timer for battery
Timer timer_debug;                                                       // timer for entering the debug mode   
static bool debug_mode=false;                                               // holds the status of the debug mode "1" indicates the device is in debug mode 
char debug_message_rx[6];                                               // buffer to receive the debug message data
char debug_message[6]={"debug"};                                        //debug message to be received
void debug_status_monitoring();                                         // debug status monitoring
static uint32_t pid = 0;                                                    // patient ID    
static uint8_t state_touch = 1;                                                 //added on 16-NOV rashmi 
uint8_t buffer_pointer = 0x00u;  
static uint8_t device_id = 0;
                                
int main()
{
    static DEVICE_MAIN_STATE main_state = GET_TOUCH_DISP_STATE;
    static uint8_t state_display = 0;
    //static uint8_t state_touch = 1;                                           //commented on 16-NOV rashmi 
    uint8_t state_t = 1;                                     // state to transmit to bluetooth
    uint8_t state_r = 0;                                     // state to receive from bluetooth
  
    //DisableTouch();
    gc.baud(115200);
    blue1.baud(115200);
    sd.disk_initialize();
    sd_card_status();                                                         
    pid = get_filepid() + 1;                                                    //added on 22/09/2017 nikita
    //screen_main();                                                              // display of main screen 
    battery_monitor();                                                          // monitor battery at the start only
    //battery_status_display();                                                   // display of main screen
    timer_battery.start();
    timer_debug.start();
    read_device_id();
    gc.printf("enter message to go into debug mode\n");
   
   while(1)
   {
    
        if (read_debug_status() == false)                                            // checking the debug_mode status
        {   
            if(timer_debug.read_ms()<TIMER_ENTER_DEBUG_MODE)
            {
                debug_status_monitoring();
            }
        }   
      
        battery_status_monitoring();                                            // to  monitior battery status after every 10 min. 

        if(false)// (get_battery_status() == BATTERY_SCREEN_NO_CHARGE_CONDITION)   // to check battery status and take action 
        {        
                 //DisableTouch();
        }
        else
        {
            //EnableTouch();
            //gc.printf("c");
            //gc.printf("main state: %d\n",main_state);
            switch(main_state)                                              // main state machine
             {
                case GET_TOUCH_DISP_STATE:

                    state_display = poc2p0_bt_receive(state_touch);
                    //state_display = touch(state_touch);                   // touch state
                    //gc.printf(" state_display = %d\n", state_display);
                    display(state_display);                                 //display state
                    
                    if(state_display == 15)
                    {
                        main_state = GET_TOUCH_DISP_STATE;
                    }
                    if(state_display == 12)
                    {
                        main_state = BT_TX_STATE;
                    }
                   // else
                   //   display(state_display);  

                    break;
    
                case BT_TX_STATE:
                        //DisableTouch();                                             // bluetooth send 
                        timer_bt.start();
                         if(get_timer_bluetooth()<TIMER_RXACK_BTCONNECTION)                           // bluetooth connection timer 15 sec
                         {
                        
                            if(BT==1)                                                    // checking for bluetooth connection
                            {
                    
                               timer_bt.stop();                                        // stop the timer once connected to app
                               timer_bt.reset(); 
                               //BT_connection() ;                                // displaying connection on bluetooth 
                               gc.printf(" BT Connected\n");
                               state_r=bt_send(state_t);
                               timer_bt.start();
                                //gc.printf(" state_t = %d\n", state_t);
                                // gc.printf(" state_r = %d\n", state_r);   
                                if (state_r==0)                                  // if the state received is zero, then there is no new file to send
                                    {
                                        timer_bt.stop();                           // stop the timer once connected to app
                                        timer_bt.reset();
                                        //BT_finished();                         // screen to display communication finished
                                        //screen_BT_return();                    //screen to return back
                                        gc.printf("BT Transfer Complete\n");
                                        //EnableTouch();
                                        main_state=GET_TOUCH_DISP_STATE;
                                        state_touch=12;
                                        break;
                                     }
                                   
                                else 
                                    {
                                        main_state=BT_RX_STATE;                           // move to receving stste of bluetooth
                                    }
                          
                            }  
                  
                            else   
                            {
                             //BT_no_connection();     // display screen to show that there is no connection
                             gc.printf("BT No Connection\n");
                            }
                         }

                        else
                        {
                            poc2p0_send_device_msg_res(MSG_REJECTED_RES);       //added on 14-Nov by rashmi                                   
                            //BT_no_connection();                                 // display screen to show that there is no connection
                            gc.printf("stopped");
                            //screen_BT_return();                                 // button to return
                            //EnableTouch();
                            main_state=GET_TOUCH_DISP_STATE;
                            state_touch=12;
                            //sd_close();  
                            timer_bt.stop();
                            timer_bt.reset();
                        }
                        break;
                 
                case BT_RX_STATE:
                        //DisableTouch();  
            
                        if(get_timer_bluetooth()<TIMER_RXACK_BTCONNECTION)
                        {
                            if (blue1.readable())         // if there is data to receive enter the loop
                            {
                               
                                state_t=bt_receive(state_r);
                               //  gc.printf(" state_t = %d\n", state_t);
                                // gc.printf(" state_r = %d\n", state_r);
                                timer_bt.stop();
                                timer_bt.reset();
                                if(state_t ==0)           // if state_t is zero, there is no other file to send
                                 {
                                  
                                    //BT_finished();
                                    //screen_BT_return();  
                                    gc.printf("BT Transfer Complete\n");
                                    //EnableTouch();
                                    main_state=GET_TOUCH_DISP_STATE;
                                    state_touch=12;  // jumping to touch case 12
                                    break;
                                  } 
                                else                                 // move to bluetooth transmit if the states are 1,2,3,4
                                 {
                                    main_state=BT_TX_STATE;
                                 }  
                            }
                         }                 
                   
                        else 
                        {    
                            //DisableTouch();
                            //BT_no_connection();                     // display screen to show that there is no connection
                            gc.printf("stopped");
                            //screen_BT_return();                     // button to return
                            gc.printf("BT No Connection\n");
                            //EnableTouch();
                            main_state=GET_TOUCH_DISP_STATE;
                            state_touch=12;
                            state_t = 1;                                     // state to transmit to bluetooth
                            state_r = 0;                                     // state to receive from bluetooth
                            sd_close();                             ///close the opened file which was used for bluetooth
                            timer_bt.stop();
                            timer_bt.reset();
                        }
                        break;
                default:
                    break;
             }         
        }        
   } 

}
/*uint8_t touch(uint8_t state)
{
   static  uint8_t state1=0;
   detect_touch(state);                                             // determine the touch points
    
    switch(state)                                                   // state for touch
  {
      case 1:   
                state1=touch_main();                                // determining the touch for main screen 
                state=0;
                nstate1=state1;
                break;
               
      case 2: 
                state1=touch_main_1();                              // determining the touch for SYSTEM CONFIGURATION screen 
                state=0;
                nstate1=state1;
                break;
                
      case 3:  
                state1=touch_main_2();                              // determining the touch for TEST screen                 
                state=0;
                nstate1=state1;
                break;
        
      case 4: 
                state1=touch_glc();                                 // determining the touch for GLC screen 
                state=0;
                nstate1=state1;
                break;       
        
      case 5: 
                state1=touch_ecg();                                 // determining the touch for ECG screen 
                state=0;
                nstate1=state1;
                 break;   
     case 6: 
                state1=touch_ret();                                 // determining the touch for returning back to the main screen      
                state=0;
                nstate1=state1;
                break;
                
     case 7: 
                state1=touch_again_ecg();                          // determining the touch when readings are taken more than once screen 
                state=0;
                nstate1=state1;
                break;
                
     case 8:    
                state1=touch_bp();                                  // determining the touch for BP screen 
                state=0;
                nstate1=state1;
                break;           
                
     case 9:    
                state1=touch_again_glc();  
                state=0;
                nstate1=state1;
                break;            
                
     case 10 :  
                DisableTouch();
                wait_ms(300);
                EnableTouch();
                state=nstate;
                break;
                  

      case 11:   
                state1=touch_again_bp();            
                state=0;
                nstate1=state1;
                break;
      
      case 12:   
                state1=BT_return();            
                state=0;
                nstate1=state1;
                break;
         
      case 13:  
                state1 = touch_debug();                                         //touch state for debug
                //state=0;
                nstate1=state1;
                break;  
     default :  
                DisableTouch();
                wait_ms(300);
                EnableTouch();
                state=nstate;
                break;          
                          
    }         
     
    return state1;
}*/
  
  
uint8_t display(uint8_t state1)
{
    static uint8_t state=0;
    static uint8_t ecg_flag=0;                                  // ecg_flag to indicate the ecg test is already done for the same pid
    static uint8_t glc_flag=0;                                  // glc_flag to indicate the glc test is already done for the same pid
    
    switch(state1)                                                              // state for display screens
    {

      
      case 1: 
                //screen_main();                                                  //  main screen 
                state1=0;
                state=1;
                nstate=state;
                ecg_flag=0;                                                     // ecg, glc flag to determine whether the readings are taken more than once
                glc_flag=0;
                clear_filecreated_status();
                //battery_status_display();                                       //Display battery status on LCD
                pid = get_filepid() + 1;
                state_touch = TOUCH_STATE_HOME_SCREEN;                          //added on 16-Nov rashmi
                break;
      
      case 2: 
                //screen_main_1();                                // System configration screen 
                state1=0;
                state=2;
                nstate=state;
                //battery_status_display();                                           //Display battery status on LCD
                // timer_debug.stop();
                break;
               
      case 3: 
                //DisableTouch();                                                     
                gc.printf("pidinit=%d",pid);
                //screen_main_2(pid);     
                state1=0;
                state=3;
                nstate=state;
                //battery_status_display(); 
                state_touch = TOUCH_STATE_TEST_SCREEN;                          //added on 16-Nov rashmi
                break;
                
      case 4: 
                if (glc_flag==1)                                // glc_flag=1 when already the reading has been taken 
                {
                    //screen_again();    
                    state1=0;
                    state=9;
                    nstate=state;
                }
                else
                { 
                    //screen_glc();                                       // glc screen
                    state1=0;
                    state=4;
                    nstate=state;
                }                
                break;
     
     
     case 5:     
                if (ecg_flag==1)
                {
                    //screen_again();
                    state1=0;
                    state=7;
                    nstate=state;
                }
                
                else
                {   
                    //screen_ecg();                                           //ecg main screen 
                    state1=0;
                    state=5;
                    nstate=state;
                }
                break;
     
     case 6:   
                //screen_bp();                                                 // bp main screen
                state1=0;
                state=8;
                nstate=state;                
                break;
     
     case 7:      
                glc(pid);                                                       // glc measurement
                glc_flag=1;
                state1=0;
                state=6;
                eprom_write_8(30,0);
                nstate=state;                                   
                state_touch = TOUCH_STATE_TEST_SCREEN;                     
                
                break;
    
    case 8:    
                // send ECG test in progress messages to mobile application
                poc2p0_send_device_msg_res(ECG_TEST_IN_PROGRESS_RES);
                ecg_bp_countdown();
                ecg(pid);                                            // capturing ecg
                state1=0;
                ecg_flag=1;
                state=6;
                eprom_write_8(30,1);
                nstate=state;
                state_touch = TOUCH_STATE_TEST_SCREEN;                          
                break;
             
      case 9:                
                // send BP test in progress response to mobile application
                poc2p0_send_device_msg_res(BP_TEST_IN_PROGRESS_RES);
                                              
                ecg_bp_countdown();                                             // countdown for bp 
                bp(pid);                                                        // measuring bp   earlier bp() changed to bp(pid) 28/4/2017
                state1=0;
                state=6;
                eprom_write_8(30,2);
                nstate=state;                                      
                state_touch = TOUCH_STATE_TEST_SCREEN;                          
                 break;
 
                          
      case 10 :  //DisableTouch();
                 wait_ms(300);
                 //EnableTouch();
                 state=nstate;
                  break;        
                  
      case 11 :    
                //screen_patient_info(get_filepid(), get_btpid());
                state1=0;
                state=12;
                break;  
                         
      case 13 :                                                                 //display screen for debug
                state1=0;
                state=13;
                nstate=state;
                break; 
                   
      case 14 :                                         
                delete_sdcard();                                                // delete SD card
                state1=0;
                state= 12;
                nstate=state;
                break;   
                
        case 15 :    
                gc.printf("Total Patients' data available : %d\n",get_filepid());                                        //state to read SD card
                gc.printf("Enter the PID number");
                read_sdcard_file();
                state1=0;
                state= 12;
                nstate=state;
                break;                            
       
        default :  

                  state1=nstate1;
                   break;


    }            

    return state;       

}


bool get_filecreated_status(void)                                               //function to get file created status
{
    return file_created_status;
}

void set_filecreated_status(void)                                               //function to set file created status
{
    file_created_status = true;
}


void clear_filecreated_status(void)                                             //function to clear file created status
{
    file_created_status = false;
}

void increment_filepid (void)                                                       //increment pid if a test is completed
{
    sd_read(filepid_btpid);                                                     //read pid from sd card
    filepid_btpid[0] = filepid_btpid[0] + 1;                                    //increment it by 1
    sd_write(filepid_btpid);                                                    //write it back to sd card  
} 

void increment_btpid (void)                                                      //increment pid if a test is completed
{
    sd_read(filepid_btpid);                                                     //read pid from sd card
    filepid_btpid[1] = filepid_btpid[1] + 1;                                    //increment it by 1
    sd_write(filepid_btpid);                                                    //write it back to sd card
    
} 

uint32_t get_filepid(void)
{ 
    uint32_t filepid = 0;    
    
    sd_read(filepid_btpid);                                                           //read pid from sd card
    filepid = filepid_btpid[0];                                  
    return filepid; 
    
}   

void store_filepid(uint32_t pid)
{
    sd_read(filepid_btpid);                                                       //read pid from sd card
    filepid_btpid[0] = pid;                                              
    sd_write(filepid_btpid);                                                      //write it back to sd card
                                                        
} 

uint32_t get_btpid(void)
{
    uint32_t btpid = 0;    
    
    sd_read(filepid_btpid);                                                           //read pid from sd card
    btpid = filepid_btpid[1];                                  
    return btpid;  
}   

void store_btpid(uint32_t bt_pid)
{     
    sd_read(filepid_btpid);                                                       //read pid from sd card
    filepid_btpid[1] = bt_pid;                                              
    sd_write(filepid_btpid);                                                      //write it back to sd card
} 


uint32_t get_timer_bluetooth()
{
  return  timer_bt.read_ms(); 
} 

void battery_status_monitoring()
{
    if(timer_battery.read_ms() > BATTERY_TIMER_VALUE ) 
    {
        battery_monitor();
        timer_battery.reset();
    }
}

bool read_debug_status()
{
   // gc.printf("debug_mode=%d\n",debug_mode); 
    return debug_mode;
}

void debug_status_monitoring()
{
 if (gc.readable())                                                             // check for the user input
        {
            
           while (gc.readable()!= '\n')                                         // read till the newline
            { 
               
                gc.scanf("%s", debug_message_rx);                               // store the message typed in buffer
                gc.printf("%s", debug_message_rx);
                break;
            }
         
         
            if (strcmp(debug_message_rx, debug_message) == 0)                   // compare the message with the required one
            {
                 debug_mode = true;                                             // enable the debug mode status
                 gc.printf("entered into debug mode\n");
                 timer_debug.reset();
                 timer_debug.start();                                           // timer is started in orede
            } 
        }        
    
}  
    
uint32_t get_timer_debug()                                                      // timer for enabling debug option
{
  if(timer_debug.read_ms()>TIMER_ENABLE_DEBUG_MODE)
    {
        timer_debug.stop();
    }
  return  timer_debug.read_ms(); 
}

// this command response to all the remaining command which doesn't have any data in response
void poc2p0_send_device_msg_res(uint8_t response_cmd)
{
        
    poc2p0_device_msg_response  poc2p0_device_msg_res = {0x00u};

    poc2p0_device_msg_res.sos = SOS_EOS;
    poc2p0_device_msg_res.cmd = response_cmd;
    poc2p0_device_msg_res.length = ZERO_DATA_LEN;

    poc2p0_device_msg_res.eos = SOS_EOS;

    poc2p0_device_msg_res.chksum = checksum_struct((uint8_t *)&poc2p0_device_msg_res.cmd, (sizeof(poc2p0_device_msg_res)-1));

    blue1.printf("%02x",poc2p0_device_msg_res.sos);
    blue1.printf("%02x",poc2p0_device_msg_res.cmd);
    blue1.printf("%02x",poc2p0_device_msg_res.length);
    blue1.printf("%02x",poc2p0_device_msg_res.eos);
    blue1.printf("%02x",poc2p0_device_msg_res.chksum);
    blue1.printf("\n");
    
    gc.printf("%02x",poc2p0_device_msg_res.sos);
    gc.printf("%02x",poc2p0_device_msg_res.cmd);
    gc.printf("%02x",poc2p0_device_msg_res.length);
    gc.printf("%02x",poc2p0_device_msg_res.eos);
    gc.printf("%02x",poc2p0_device_msg_res.chksum);
    gc.printf("\n");
}

// this command response to heartbeat message request send by bluetooth device
void poc2p0_send_device_heartbeat_msg_res(uint8_t curr_touch_state)
{    
    poc2p0_device_heartbeat_response    poc2p0_device_heartbeat_res = {0x00u};
       
    // RTC operations
    time_t epoch_time_glc;                              //A copy of time_t by name  epoch_time_bp is created
    struct tm * ptr_time_info_glc;                      // Sturucture copy of tm is created

    epoch_time_glc = rtc_read();                        // time is got from get epoch function.
    ptr_time_info_glc = localtime(&epoch_time_glc);     // Structure accepts the time in local format from "time_t" type.

    poc2p0_device_heartbeat_res.sos = SOS_EOS;
    poc2p0_device_heartbeat_res.cmd = HEARTBEAT_SYNC_MSG_ACCEPTED_RES;
    poc2p0_device_heartbeat_res.length = HEARTBEAT_DATA_LEN;

    // device ID
    poc2p0_device_heartbeat_res.did = eprom_read_8(12);

    // patient ID
    if (curr_touch_state == TOUCH_STATE_TEST_SCREEN)
    {
        memcpy(poc2p0_device_heartbeat_res.pid,get_userpid(),sizeof(poc2p0_device_heartbeat_res.pid));               
    }
    else 
    {
        memset(poc2p0_device_heartbeat_res.pid,'0',sizeof(poc2p0_device_heartbeat_res.pid));
        gc.printf("poc2p0_device_heartbeat_res.pid = %s\n",poc2p0_device_heartbeat_res.pid);
        
    }

    // device current date and time
    poc2p0_device_heartbeat_res.date_time.date = (uint8_t)(*ptr_time_info_glc).tm_mday;
    poc2p0_device_heartbeat_res.date_time.month = (uint8_t)(*ptr_time_info_glc).tm_mon+1;
    poc2p0_device_heartbeat_res.date_time.year = (uint8_t)(*ptr_time_info_glc).tm_year-100;
    poc2p0_device_heartbeat_res.date_time.hour = (uint8_t)(*ptr_time_info_glc).tm_hour;
    poc2p0_device_heartbeat_res.date_time.mins = (uint8_t)(*ptr_time_info_glc).tm_min;
    poc2p0_device_heartbeat_res.date_time.sec = (uint8_t)(*ptr_time_info_glc).tm_sec;

    // device state
    if (curr_touch_state == TOUCH_STATE_HOME_SCREEN)
    {
        poc2p0_device_heartbeat_res.device_state = HOME_SCREEN;
    }
    else
    {
        poc2p0_device_heartbeat_res.device_state = TEST_SCREEN;
    }
    
    //poc2p0_device_heartbeat_res.device_state = device_state;

    // device battery status
    poc2p0_device_heartbeat_res.battery_status = get_battery_status();

    poc2p0_device_heartbeat_res.eos = SOS_EOS;

    // calculate chksum
    poc2p0_device_heartbeat_res.chksum = checksum_struct((uint8_t *)&poc2p0_device_heartbeat_res.cmd, (sizeof(poc2p0_device_heartbeat_res)-1));
   
    blue1.printf("%02x",poc2p0_device_heartbeat_res.sos);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.cmd);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.length);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.did);
    //blue1.printf("%010x",poc2p0_device_heartbeat_res.pid);
    for (uint8_t i = 0; i < sizeof(poc2p0_device_heartbeat_res.pid); i++)
    {
        blue1.printf("%02x",poc2p0_device_heartbeat_res.pid[i]);
    }
    blue1.printf("%02x",poc2p0_device_heartbeat_res.date_time.date);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.date_time.month);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.date_time.year);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.date_time.hour);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.date_time.mins);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.date_time.sec);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.device_state);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.battery_status);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.eos);
    blue1.printf("%02x",poc2p0_device_heartbeat_res.chksum);
    blue1.printf("\n");
    
    gc.printf("%02x",poc2p0_device_heartbeat_res.sos);
    gc.printf("%02x",poc2p0_device_heartbeat_res.cmd);
    gc.printf("%02x",poc2p0_device_heartbeat_res.length);
    gc.printf("%02x",poc2p0_device_heartbeat_res.did);
    //gc.printf("%010x",poc2p0_device_heartbeat_res.pid);
    for (uint8_t i = 0; i < sizeof(poc2p0_device_heartbeat_res.pid); i++)
    {
        gc.printf("%02x",poc2p0_device_heartbeat_res.pid[i]);
    }
    gc.printf("%02x",poc2p0_device_heartbeat_res.date_time.date);
    gc.printf("%02x",poc2p0_device_heartbeat_res.date_time.month);
    gc.printf("%02x",poc2p0_device_heartbeat_res.date_time.year);
    gc.printf("%02x",poc2p0_device_heartbeat_res.date_time.hour);
    gc.printf("%02x",poc2p0_device_heartbeat_res.date_time.mins);
    gc.printf("%02x",poc2p0_device_heartbeat_res.date_time.sec);
    gc.printf("%02x",poc2p0_device_heartbeat_res.device_state);
    gc.printf("%02x",poc2p0_device_heartbeat_res.battery_status);
    gc.printf("%02x",poc2p0_device_heartbeat_res.eos);
    gc.printf("%02x",poc2p0_device_heartbeat_res.chksum);
    gc.printf("\n"); 
}

// this command send final test result response to bluetooth device
void poc2p0_send_device_test_result_res(uint8_t response_cmd, uint32_t result)
{    
    poc2p0_device_tst_result_response   poc2p0_device_tst_result_res = {0x00u};

    poc2p0_device_tst_result_res.sos = SOS_EOS;
    poc2p0_device_tst_result_res.cmd = response_cmd;
    poc2p0_device_tst_result_res.length = DEVICE_RESULT_DATA_LEN;

    // device result provided by device
    poc2p0_device_tst_result_res.test_result = result;

    poc2p0_device_tst_result_res.eos = SOS_EOS;

    poc2p0_device_tst_result_res.chksum = checksum_struct((uint8_t *)&poc2p0_device_tst_result_res.cmd, (sizeof(poc2p0_device_tst_result_res)-1));

    blue1.printf("%02x",poc2p0_device_tst_result_res.sos);
    blue1.printf("%02x",poc2p0_device_tst_result_res.cmd);
    blue1.printf("%02x",poc2p0_device_tst_result_res.length);
    blue1.printf("%08x",poc2p0_device_tst_result_res.test_result);
    blue1.printf("%02x",poc2p0_device_tst_result_res.eos);
    blue1.printf("%02x",poc2p0_device_tst_result_res.chksum);
    blue1.printf("\n");  
    
    gc.printf("%02x",poc2p0_device_tst_result_res.sos);
    gc.printf("%02x",poc2p0_device_tst_result_res.cmd);
    gc.printf("%02x",poc2p0_device_tst_result_res.length);
    gc.printf("%08x",poc2p0_device_tst_result_res.test_result);
    gc.printf("%02x",poc2p0_device_tst_result_res.eos);
    gc.printf("%02x",poc2p0_device_tst_result_res.chksum);
    gc.printf("\n");  
}

static void ecg_bp_countdown(void)
{
    for(uint8_t i = 5; i <= 0; i--)
    {
        wait(1);
    }
}

static void read_device_id(void)                                                // reading device id from eeprom
{
    
    device_id =  eprom_read_8(12);                                              // reading did from eeprom location 
    gc.printf("device_id = %d\n", device_id);                                                     
    if((get_Error()!= 0) || (device_id == 0xFF))                                // checking for error                               
    {
            device_id = eprom_read_8(12) ; 
         if(get_Error()!= 0  || (device_id == 0xFF))  
            {
                gc.printf("database error!\n");                                 // database error
                //return did; 
            }
    }
     
}

uint8_t get_did()
{
    return  device_id;
}

void sd_card_status(void)                                                       // checking the status of the sd card initialization
{
 uint8_t error_sd= 0;
 error_sd = dummy_file_create_delete();                                         // creating the dummy file

 if( error_sd == 1)                                                             // if error = 1 // error in opening file 
 {
       error_sd = dummy_file_create_delete(); 
        if( error_sd == 1)
            {
                gc.printf("database error!\n");                                 // dispaly data base error
                //database_error();
              
            }
 }
 
} 

