#ifndef EC_BP_H_
#define EC_BP_H_

typedef void (*func_ptr)(void) ; /*creates typedef to function pointer, does not take any arguement and returns void*/

void doHelp(void) ;
void doStatus(void) ;
void doFreq(void) ;
void doMode(void) ;
void doBit(void) ;
void doWrite(void) ;
void doWrite2(void) ;
void doRead(void) ;
void doLoop(void) ;
void setup(void);
void testsetup(void);
void ecgsetup();
void regWrite(int,int);
void cmdWrite(int);
void regRead(int);
void lpf_coef(void);
float lpf( float coeff[5], float);
void drdy_int(void);
void freqset();
void ecgtestsetupfunc();

#define PIN_MOSI        PTA16
#define PIN_MISO        PTA17 
#define PIN_SCLK        PTD1 
#define MA4_SIZE  4 // DO NOT CHANGE
//SDFileSystem sd(PTE1, PTE3, PTE2, PTE4, "sd");

//SPI commands
#define CMD_WAKEUP 0x02
#define CMD_STANDBY 0x04
#define CMD_RESET 0x06
#define CMD_START 0x08
#define CMD_STOP 0x0A
#define CMD_OFFSET_CAL 0x1A
#define CMD_RDATAC 0x10
#define CMD_SDATAC 0x11
#define CMD_RDATA 0x12
//Note the following commands are 3 bits and have the following structure
// CMD_REGr_rrrr; where r_rrrr is the register address given below
#define CMD_WREG  0x02
#define CMD_RREG 0x01

//SPI registers addresses, 5 bits width
#define REG_ID  0x00
#define REG_CONFIG1 0x01
#define REG_CONFIG2 0x02
#define REG_LOFF 0x03
#define REG_CH1SET 0x04
#define REG_CH2SET 0x05
#define REG_RLD_SENS 0x06
#define REG_LOFF_SENS 0x07
#define REG_LOFF_STAT 0x08
#define REG_MISC1 0x09
#define REG_MISC2 0x0A
#define REG_GIPO 0x0B

//Register bit configurations
#define sps500 0x02   //CONFIG1 REG bits 010
#define sps125 0x00   //CONFIG1 REG bits 000
#define sps1k 0x03    //CONFIG1 REG bits 011
#define no_mode 0xA8    //CONFIG2 REG set to zero for device check
#define test_mode 0xA3  //CONFIG2 REG bits set to test mode, to generate a square wave
#define default_mode 0xE0   //CONFIG2 REG bits set to default mode, to generate ECG signal from an external input
#define loff_conf 0xF0  //LOFF register bits set to F0 to configure LOFF reg for leadoff detection
#define offset_meas 0x01    //CH1SET REG set to Gain = 6 and offset measurement
#define test_inp 0x05       //CH1SET REG set to Gain = 6 and generate test signal
#define elec_inp 0x00       //CH1SET REG set to Gain = 6 and take in electrode input
#define rld_sens_sig 0x23
#define loff_sens_sig 0x03 
#define misc1_inp 0x02
#define misc2_inp 0x03

#define LSHIFT_8 8    //left shift the obtained 8bit data by 8 values
#define LSHIFT_16 16  ////left shift the obtained 8bit data by 16 values
#define N_ERR 100
#define N_TEST 500
#define N_ECG 2000


//SPI SETTINGS
#define baud_rate 115200
#define freq 1000000
#define bits 8 
#define mode 1 
#define loop 1000000 

//PPG DECLARATION
#define MAX_BRIGHTNESS 255 // BP ADD
 void setupfunc();
uint8_t ecgsetupfunc();
 uint32_t readvalue();
#endif



