#include "mbed.h"
#include "SerialGPS.h"

 
Serial pc(USBTX, USBRX); // tx, rx
SerialGPS gps(PA_9,PA_10);  // tx, rx




/**
 * A callback function for logging data.
 */
void cbfunc_log(char *s) {

}

/**
 * A callback function for GGA.
 *
 * GGA - Global Positioning System Fixed Data.
 */
void cbfunc_gga(SerialGPS::gps_gga_t *p) {

        pc.printf("%02d:%02d:%02d(P%d,S%d)\r\n", p->hour, p->min, p->sec, p->position_fix, p->satellites_used);

        pc.printf("%c=%10.4f\r\n", p->ns, p->latitude);

        pc.printf("%c=%10.4f\r\n", p->ew, p->longitude);
    
}

/**
 * A callback function for GSA.
 *
 * GSA - GNSS DOP and Active Satellites.
 */
void cbfunc_gsa(SerialGPS::gps_gsa_t *p) {

        pc.printf("SEL:%c FIX:%d\r\n", p->selmode, p->fix);
  
}

/**
 * A callback function for GSV.
 *
 * GSV - GNSS Satellites in View.
 */
void cbfunc_gsv(SerialGPS::gps_gsv_t *p) {
 
        pc.printf("Satellites:%2d\r\n", p->satcnt);

}

/**
 * A callback function for RMC.
 *
 * RMC - Recommended Minimum Specific GNSS Data.
 */
void cbfunc_rmc(SerialGPS::gps_rmc_t *p) {

        pc.printf("%02d:%02d:%02d(%c)\r\n", p->hour, p->min, p->sec, p->status);

}

/**
 * Entry point.
 */



 
int main() {
    
    pc.baud(9600);
    
    
    pc.printf("TEST\r\n");
    wait(0.5);
    //wait(0.5);
    SerialGPS::gps_callback_t cb;
    cb.cbfunc_log = cbfunc_log;
    cb.cbfunc_gga = cbfunc_gga;
    cb.cbfunc_gsa = cbfunc_gsa;
    cb.cbfunc_gsv = cbfunc_gsv;
    cb.cbfunc_rmc = cbfunc_rmc;
    gps.attach(&cb);
    
    while(1) {
        

        gps.processing();
        //wait(0.5);
    }
}

