#include "speech.h"
#include "globals.h"
#include "hardware.h"

void stairs_speech(int state)
{
    if(!state) {
        const char* lines[] = { "Uhoh. History",
                                "needs your help.",
                                "Go and speak to",
                                "the NPC for",
                                "more info."
                              };
        long_speech(lines, 5);
    }
    if(state) {
        const char* lines[] = { "Thanks for using",
                                "the Time Teleport",
                                "Train(TM)!",
                                " ",
                                "Teleporting...",
                                "Hang on!"
                              };
        long_speech(lines, 6);
    }
}
void npc_speech(int state)
{
    switch(state) {
        case 0: {
            const char* lines[] = { "Fellow traveler! ",
                                    "We need your help",
                                    "It is now 2030. ",
                                    "In the year 2021",
                                    "Aliens took over",
                                    "Earth! They took",
                                    "everything here!",
                                    "We need your help",
                                    "to defeat them! ",
                                    "Travel through",
                                    "the portals",
                                    "on the map to",
                                    "save this planet",
                                    "once and",
                                    "for all!"
                                  };
            long_speech(lines, 15);
            break;
        }
        case 1: {
            const char* lines[] = { "To save Earth,",
                                    "travel through",
                                    "the portals",
                                    "found on the map",
                                    "The portals will",
                                    "bring you back",
                                    "to 2021, where",
                                    "you can defeat ",
                                    "the aliens and",
                                    "stop them from",
                                    "taking over!",
                                  };
            long_speech(lines, 11);
            break;
        }
        case 2: {
            const char* lines[] = { "You did it! You",
                                    "killed the aliens",
                                    "and saved Earth! ",
                                    "As a small reward",
                                    "please take this",
                                    "key I found!",
                                    "It's the least",
                                    " that I can do."
                                  };
            long_speech(lines, 8);
            break;
        }
        case 3: {
            const char* lines[] = { "Thanks again for ",
                                    "saving our planet",
                                    "Hopefully you",
                                    "can use the key,",
                                    "I have no idea",
                                    "where it goes!"
                                  };

            long_speech(lines, 6);

            break;
        }

    }
}
void boss_speech(int state)
{
    switch(state) {
        case 0 : {
            const char* lines[] = { "I am Albert the ",
                                    "Alien! I plan to",
                                    "destroy Earth!",
                                    "However,you've",
                                    "stopped me here,",
                                    "so I'll give you",
                                    "one chance. One",
                                    "One of these ",
                                    "spells kills you",
                                    "one kills me,",
                                    "and one does ",
                                    "nothing. Choose",
                                    "the correct",
                                    "spell, and I die.",
                                    "Choose the wrong",
                                    "spell, and you ",
                                    "get VERY hurt!",
                                    "Choose wisely!",
                                    "Earth's fate",
                                    "is in your hands",
                                  };
            long_speech(lines, 20);
            break;

        }
        case 1: {
            const char* lines[] = { "I see you met my",
                                    "clone! Now for",
                                    "tne real test!",
                                    "Choose between",
                                    "red and blue.",
                                    "One will KILL you",
                                    "and one will KILL",
                                    "me. May the odds",
                                    "be ever in your",
                                    "favor!"
                                  };
            long_speech(lines, 10);
            break;
        }
        case 2: {
            const char* lines[] = { "Go back to the",
                                    "previous map!",
                                    "I don't do ",
                                    "anything yet!"
                                  };
            long_speech(lines, 4);
            break;
        }


    }
}
void spell_speech(int state)
{
    switch(state) {
        case 0 : {
            const char* lines[] = { "Speak to the",
                                    "boss! I don't do",
                                    "anything yet..."
                                  };
            long_speech(lines, 3);
            break;
        }
        case 1: {
            char spell1[] = "You cast lava!";
            speech(spell1, NULL);
            break;
        }
        case 2: {
            char spell2[] = "You cast water!";
            speech(spell2, NULL);
            break;
        }
        case 3: {
            char spell3[] = "You cast peanuts!";
            speech(spell3, NULL);
            break;
        }
        case 4: {
            char spell4[] = "You chose red!";
            speech(spell4, NULL);
            break;

        }
        case 5: {
            char spell4[] = "You chose blue!";
            speech(spell4, NULL);
            break;
        }
        case 6: {
            char correct_spell[] = "Super effective!";
            speech(correct_spell, NULL);
            const char* lines[] = { "Oh no! How did ",
                                    "you know I was ",
                                    "deathly allergic",
                                    "to peanuts?!?",
                                    "I guess that's it",
                                    " for me...",
                                    "NOOOOO!!!!!!",

                                  };
            long_speech(lines, 7);
            break;

        }
        case 7: {
            char incorrect_spell[] = "It does nothing!";
            speech (incorrect_spell, NULL);
            break;
        }
        case 8: {
            const char* lines[] = { "Albert is dead!",
                                    "Head back to",
                                    "the NPC!",
                                    "You did it!"
                                  };
            long_speech(lines, 4);
            break;
        }

        case 9: {
            const char* lines [] = { "How did you know",
                                     "know I'm deathly",
                                     "allergic to nuts!",
                                     "Too bad I'm just",
                                     "a clone of the",
                                     "real boss!"
                                   };
            long_speech(lines, 6);
            break;
        }
        case 10: {
            const char* lines[] = { " Head through",
                                    "through the top",
                                    "right portal to",
                                    "fight the real me",
                                    "and prove your",
                                    "skills once and",
                                    "for all!"
                                  };
            long_speech(lines, 7);
            break;
        }
        case 11: {
            const char* lines[] = { "Oh no! You burned",
                                    "yourself in lava!",
                                    "It looks fatal!"
                                  };
            long_speech(lines, 3);
            break;
        }
        case 12: {
            const char* lines[] = { "Rookie mistake!",
                                    "Everyone knows ",
                                    "not to choose the ",
                                    "red pill! Kiss ",
                                    "your planet",
                                    "goodbye!!! "
                                  };
            long_speech(lines, 6);
            break;
        }
        case 13: {
            const char* lines[] = { "You picked",
                                    "correctly! I ",
                                    "should have ",
                                    "figured everyone",
                                    "would pick the",
                                    "red pill. Guess",
                                    "that's it for me!",
                                    "Goodbye for now!"
                                  };

            long_speech(lines, 8);
            break;
        }
    }
}