#include "map.h"

#include "globals.h"
#include "hash_table.h"
#include "graphics.h"

/**
 * The Map structure. This holds a HashTable for all the MapItems, along with
 * values for the width and height of the Map.
 * In this file you need to define how the map will be structured. IE how will
 * you put values into the map, pull them from the map. Remember a "Map" variable
 * is a hashtable plus two ints (see below)
 * You will have more than one map variable, one will be the main map with it's own hashtable.
 * Then you'll have a second map with another hashtable
 * You should store objects into the hashtable with different properties (spells
 * etc)
 */
struct Map {
    HashTable* items;
    int w, h;
};

/**
 * Storage area for the maps.
 * This is a global variable, but can only be access from this file because it
 * is static.
 */
static Map map[3];
static int active_map;


/**
 * The first step in HashTable access for the map is turning the two-dimensional
 * key information (x, y) into a one-dimensional unsigned integer.
 * This function should uniquely map (x,y) onto the space of unsigned integers.
 */
static unsigned XY_KEY(int X, int Y)
{
    return (Y * map_width()) + X;
}

/**
 * This is the hash function actually passed into createHashTable. It takes an
 * unsigned key (the output of XY_KEY) and turns it into a hash value (some
 * small non-negative integer).
 */
unsigned map_hash(unsigned key)
{
    return key % NUM_BUCKETS;
}

void maps_init()
{

    if(map[0].items!= NULL) {
        destroyHashTable(map[0].items);
    }
    if(map[1].items!= NULL) {
        destroyHashTable(map[1].items);
    }
    if(map[2].items!= NULL) {
        destroyHashTable(map[2].items);
    }

    map[0].items = createHashTable(map_hash, NUM_BUCKETS);
    map[0].w = mainMapWidth;
    map[0].h = mainMapHeight;
    map[1].items = createHashTable(map_hash, NUM_BUCKETS);
    map[1].w = bossMapWidth;
    map[1].h = bossMapHeight;
    map[2].items = createHashTable(map_hash, NUM_BUCKETS);
    map[2].w = map3Width;
    map[2].h = map3Height;

    // TODO: Implement!
    // Initialize hash table
    // Set width & height
}

Map* get_active_map()
{

    return &map[active_map];
}
int get_active_map_int(){
    
    return active_map;
    }

Map* set_active_map(int m)
{
    active_map = m;
    return &map[active_map];
}

void print_map()
{
    // As you add more types, you'll need to add more items to this array.
    char lookup[] = {'W', 'P'};
    for(int y = 0; y < map_height(); y++) {
        for (int x = 0; x < map_width(); x++) {
            MapItem* item = get_here(x,y);
            if (item) pc.printf("%c", lookup[item->type]);
            else pc.printf(" ");
        }
        pc.printf("\r\n");
    }
}

int map_width()
{
    Map* currMap = get_active_map();
    return currMap->w;
}

int map_height()
{
    Map* currMap = get_active_map();
    return currMap->h;
}

int map_area()
{
    Map* currMap = get_active_map();
    int area = (currMap-> h) * currMap-> w;
    return area;
}

MapItem* get_north(int x, int y)
{
    MapItem* currItem = get_here(x, y - 1);
    return currItem;
}

MapItem* get_south(int x, int y)
{
    MapItem* currItem = get_here(x, y + 1);
    return currItem;
}

MapItem* get_east(int x, int y)
{
    MapItem* currItem = get_here(x + 1, y);
    return currItem;
}

MapItem* get_west(int x, int y)
{
    MapItem* currItem = get_here(x - 1, y);
    return currItem;
}

MapItem* get_here(int x, int y)
{
    Map* currMap = get_active_map();
    unsigned key = XY_KEY(x, y);
    MapItem* currItem = (MapItem*)getItem(currMap->items, key);
    return currItem;
}


void map_erase(int x, int y)
{
    Map* curr = get_active_map();
    unsigned key = XY_KEY(x, y);
    MapItem* currItem = (MapItem*) getItem(curr->items, key);
    if(currItem) {
        deleteItem(curr->items, key);
    }

}

void add_wall(int x, int y, int dir, int len)
{
    for(int i = 0; i < len; i++) {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = WALL;
        w1->draw = draw_wall;
        w1->walkable = false;
        w1->data = NULL;
        unsigned key = (dir == HORIZONTAL) ? XY_KEY(x+i, y) : XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it
    }
}

void add_plant(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = PLANT;
    w1->draw = draw_plant;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_stairs(int x, int y, int newX, int newY, int newMap)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = STAIRS;
    w1->draw = draw_stairs;
    w1->walkable = true;
    StairsData *s1 = (StairsData*) malloc(sizeof(StairsData));
    s1 -> tx = newX;
    s1 -> ty = newY;
    s1 -> tm = newMap;
    s1 -> isLocked = 0;
    w1->data = s1;
    //stairs struct goes here
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it

}

void add_npc(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = NPC;
    w1->draw = draw_npc;
    w1->walkable = false;
    newNPC *npc1 = (newNPC*) malloc(sizeof(newNPC));
    npc1 -> x = x;
    npc1 -> y = y;
    npc1 -> state = 0;
    w1->data = npc1;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}


void add_boss(int x, int y, int corrSpell, int num)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = BOSS;
    w1->draw = draw_boss;
    w1->walkable = false;
    bossChar *b1 = (bossChar*) malloc(sizeof(bossChar));
    b1 -> x = x;
    b1 -> y = y;
    b1 -> state = 0;
    b1 -> correctSpell = corrSpell;
    b1 -> numBoss = num;
    w1->data = b1;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_spell(int x, int y, int spellType)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = SPELL;

    w1->walkable = true;
    Spell *s1 = (Spell*) malloc(sizeof(Spell));
    s1 -> x = x;
    s1 -> y = y;
    s1 -> spell_type = spellType;
    if(spellType == LAVA) {
        w1->draw = draw_fire;
    }
    if(spellType == WATER) {
        w1->draw = draw_water;
    }
    if(spellType == TACO) {
        w1->draw = draw_taco;
    }
    if(spellType == REDSP) {
        w1->draw = draw_red;
    }
    if(spellType == BLUESP) {
        w1-> draw = draw_blue;
    }
    w1->data = s1;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_door(int x, int y, int xLen, int yLen)
{
    for(int i = 0; i < xLen; i++) {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = DOOR;
        w1->draw = draw_door;
        w1->walkable = false;
        Door *d1 = (Door*) malloc(sizeof(Door));
        d1->startX = x;
        d1->startY = y;
        d1->endX = x + xLen;
        d1->endY = y + yLen;
        d1->isLocked = true;
        w1->data = d1;
        unsigned key = XY_KEY(x+i, y);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it

        MapItem* w2 = (MapItem*) malloc(sizeof(MapItem));
        w2->type = DOOR;
        w2->draw = draw_door;
        w2->walkable = false;
        Door *d2 = (Door*) malloc(sizeof(Door));
        d2->startX = x;
        d2->startY = y;
        d2->endX = x + xLen;
        d2->endY = y + yLen;
        d2->isLocked = true;
        w2->data = d2;
        unsigned key2 =  XY_KEY(x+i, y+yLen);
        void* val2 = insertItem(get_active_map()->items, key2, w2);
        if (val2) free(val2); // If something is already there, free it
    }

    for(int i = 0; i <= yLen; i++) {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = DOOR;
        w1->draw = draw_door;
        w1->walkable = false;
        Door *d1 = (Door*) malloc(sizeof(Door));
        d1->startX = x;
        d1->startY = y;
        d1->endX = x + xLen;
        d1->endY = y + yLen;
        d1->isLocked = true;
        w1->data = d1;
        unsigned key = XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it

        MapItem* w2 = (MapItem*) malloc(sizeof(MapItem));
        w2->type = DOOR;
        w2->draw = draw_door;
        w2->walkable = false;
        Door *d2 = (Door*) malloc(sizeof(Door));
        d2->startX = x;
        d2->startY = y;
        d2->endX = x + xLen;
        d2->endY = y + yLen;
        d2->isLocked = true;
        w2->data = d2;
        unsigned key2 =  XY_KEY(x+xLen, y+i);
        void* val2 = insertItem(get_active_map()->items, key2, w2);
        if (val2) free(val2); // If something is already there, free it
    }


}

void add_treasure(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = TREASURE;
    w1->draw = draw_treasure;
    w1->walkable = false;
    Treasure *t1 = (Treasure*) malloc(sizeof(Treasure));
    t1 -> x = x;
    t1 -> y = y;
    t1 -> isClaimed = false;
    w1->data = t1;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_dead(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = DEAD;
    w1->draw = draw_dead;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_hammer(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = HAMMER;
    w1->draw = draw_hammer;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}
void add_healthPotion(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = POTION;
    w1->draw = draw_healthPotion;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_heart(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = HEART;
    w1->draw = draw_heart;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_key(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = KEY;
    w1->draw = draw_key;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}
