#include "graphics.h"

#include "globals.h"

/*
In this file put all your graphical functions (don't forget to declare them first
in graphics.h). So when you want to draw something use this file. One cool function
to look at would be uLCD.blit() there are more like filled_rectangle etc...
https://os.mbed.com/users/4180_1/notebook/ulcd-144-g2-128-by-128-color-lcd/
This website is a good resource.
*/

static uint32_t duck3_arr[121] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16707840, 16707840, 0, 0, 0,
    0, 0, 0, 0, 0, 16707840, 16707840, 0, 16707840, 0, 0, 16707840, 0, 0, 0, 0, 16707840,
    16773632, 16707840, 16746496, 0, 0, 16707840, 16707840, 0, 0, 16707840, 16707840,
    16707840, 16707840, 0, 0, 0, 16707840, 16707840, 16707840, 16707840, 16707840, 16707840,
    16707840, 0, 0, 0, 0, 0, 16707840, 16707840, 16707840, 16707840, 16707840, 16707840,
    0, 0, 0, 0, 0, 0, 16707840, 16707840, 16707840, 16707840, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0
};

static int* duck3 = (int*)duck3_arr;

static uint32_t portal1_arr[121] = {
    0, 0, 0, 0, 0, 7028270, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7028270, 3516744, 7028270, 0,
    0, 0, 0, 0, 0, 0, 7028270, 3516744, 1807455, 3516744, 7028270, 0, 0, 0, 0, 7028270,
    7028270, 3516744, 1807455, 1807455, 1807455, 3516744, 7028270, 7028270, 0, 7028270,
    7028270, 3516744, 1807455, 10411914, 10411914, 10411914, 1807455, 3516744, 7028270,
    7028270, 7028270, 3516744, 1807455, 10411914, 10411914, 1807455, 10411914, 10411914,
    1807455, 3516744, 7028270, 7028270, 3516744, 1807455, 10411914, 1807455, 3516744,
    1807455, 10411914, 1807455, 3516744, 7028270, 7028270, 3516744, 1807455, 10411914,
    1807455, 3516744, 1807455, 10411914, 1807455, 3516744, 7028270, 7028270, 3516744,
    1807455, 10411914, 10411914, 1807455, 10411914, 10411914, 1807455, 3516744, 7028270,
    7028270, 3516744, 1807455, 1807455, 10411914, 10411914, 10411914, 1807455, 1807455,
    3516744, 7028270, 7028270, 3516744, 3516744, 1807455, 1807455, 10411914, 1807455,
    1807455, 3516744, 3516744, 7028270
};

static int* portal1 = (int*)portal1_arr;


static uint32_t tree_arr[121] = {
    0, 0, 0, 6929217, 8047419, 7652919, 5023061, 4825944, 0, 0, 0, 0, 6928719, 7718968,
    9888590, 10085712, 10085712, 7455797, 6995504, 6995504, 4365920, 0, 6995504, 6995504,
    10085712, 6995504, 10085712, 9954126, 9493834, 6995504, 6995504, 6863923, 3642478,
    7784504, 8047419, 10085712, 6995504, 7390004, 4102758, 6995504, 6995504, 6995504,
    3642478, 0, 0, 2135397, 7784504, 7784504, 5919319, 4405572, 7784504, 6995504, 3642478,
    0, 0, 0, 0, 2135397, 7784504, 8477784, 7356467, 3642478, 0, 0, 0, 0, 0, 0, 0, 0,
    8477784, 8013622, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8477784, 8013622, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 8477784, 8013622, 6243668, 0, 0, 0, 0, 0, 0, 0, 0, 8671032, 8013622, 6174004,
    0, 0, 0, 0, 0, 0, 0, 6702669, 9196602, 8867897, 6699313, 5715777, 0, 0, 0
};

static int* tree = (int*)tree_arr;

static uint32_t npc_arr[121] = {
    0, 0, 16313309, 16567203, 16567203, 16567203, 16567203, 16567203, 16313309, 16313309,
    0, 0, 16313309, 16313309, 16567203, 16567203, 16567203, 16567203, 16567203, 16567203,
    16313309, 0, 0, 16313309, 16313309, 16567203, 12047711, 12047711, 16567203, 12047711,
    12047711, 0, 0, 0, 0, 0, 16567203, 12047711, 12047711, 16567203, 12047711, 12047711,
    0, 0, 0, 0, 0, 16567203, 16567203, 16567203, 16567203, 16567203, 16567203, 0, 0,
    0, 0, 0, 16567203, 16313309, 16567203, 16567203, 16567203, 16313309, 0, 0, 0, 0,
    4666745, 8476330, 16313309, 16313309, 16567203, 16313309, 16313309, 4666745, 0, 0,
    0, 4666745, 8476330, 8476330, 16313309, 16313309, 16313309, 8476330, 4666745, 0,
    0, 4666745, 4666745, 8476330, 8476330, 8476330, 16313309, 8476330, 8476330, 4666745,
    0, 0, 4666745, 8476330, 8476330, 8476330, 8476330, 8476330, 8476330, 8476330, 4666745,
    0, 0, 4666745, 4666745, 4666745, 4666745, 4666745, 4666745, 4666745, 4666745, 4666745,
    0
};

static int* npc = (int*)npc_arr;

static uint32_t dead_arr[121] = {
    0, 0, 0, 16777215, 16777215, 16777215, 16777215, 16777215, 0, 0, 0, 0, 0, 16777215,
    16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 0, 0, 0, 16777215, 16777215,
    16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 0, 16777215,
    16777215, 0, 0, 16777215, 16777215, 16777215, 0, 0, 16777215, 16777215, 16777215,
    16777215, 0, 0, 16777215, 16777215, 16777215, 0, 0, 16777215, 16777215, 16777215,
    16777215, 16777215, 16777215, 16777215, 0, 16777215, 16777215, 16777215, 16777215,
    16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 0, 16777215, 16777215,
    16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215,
    16777215, 16777215, 16777215, 16777215, 16777215, 0, 16777215, 16777215, 16777215,
    16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 0, 0, 0, 16777215, 0,
    0, 16777215, 0, 0, 16777215, 0, 0, 0, 0, 16777215, 0, 0, 16777215, 0, 0, 16777215,
    0, 0
};

static int* dead = (int*)dead_arr;

static uint32_t boss_arr[121] = {
    62208, 62208, 0, 0, 0, 0, 0, 0, 0, 62208, 62208, 0, 62208, 62208, 0, 0, 0, 0, 0,
    62208, 62208, 0, 0, 0, 62208, 62208, 0, 0, 0, 62208, 62208, 0, 0, 0, 0, 62208, 62208,
    62208, 62208, 62208, 62208, 62208, 0, 0, 0, 0, 62208, 0, 0, 62208, 0, 0, 62208, 0,
    0, 62208, 62208, 62208, 0, 0, 62208, 0, 0, 62208, 62208, 62208, 62208, 0, 62208,
    62208, 62208, 62208, 62208, 62208, 62208, 0, 62208, 62208, 0, 62208, 193024, 0, 0,
    0, 193024, 62208, 0, 62208, 62208, 0, 62208, 62208, 62208, 62208, 62208, 62208, 62208,
    0, 62208, 0, 0, 62208, 0, 0, 0, 0, 0, 62208, 0, 0, 0, 0, 62208, 0, 0, 0, 0, 0, 62208,
    0, 0
};

static int* boss = (int*)boss_arr;

static uint32_t water_arr[121] = {
    0, 0, 0, 0, 0, 0, 40420, 424382, 0, 0, 0, 0, 0, 0, 0, 0, 40420, 40420, 424382, 0,
    0, 0, 0, 0, 0, 0, 40420, 40420, 424382, 0, 0, 0, 0, 0, 0, 0, 0, 40420, 40420, 40420,
    0, 0, 0, 0, 0, 0, 0, 40420, 40420, 40420, 40420, 424382, 0, 0, 0, 0, 0, 0, 40420,
    13888759, 40420, 40420, 424382, 0, 0, 0, 0, 0, 40420, 13888759, 40420, 40420, 40420,
    424382, 1190278, 0, 0, 0, 0, 40420, 13888759, 40420, 40420, 40420, 424382, 1190278,
    0, 0, 0, 0, 40420, 40420, 13888759, 40420, 424382, 424382, 1190278, 0, 0, 0, 0, 0,
    40420, 40420, 40420, 424382, 1190278, 0, 0, 0, 0, 0, 0, 0, 40420, 40420, 1190278,
    0, 0, 0, 0
};

static int* water = (int*)water_arr;



static uint32_t fire_arr[121] = {
    0, 0, 13574443, 0, 0, 0, 0, 0, 13574443, 13574443, 13574443, 0, 0, 0, 0, 0, 13574443,
    13574443, 15758881, 13574443, 0, 0, 0, 0, 13574443, 13574443, 15758881, 15758881,
    15758881, 15758881, 0, 13574443, 0, 13574443, 0, 13574443, 15758881, 13574443, 15758881,
    13574443, 13574443, 13574443, 0, 0, 13574443, 13574443, 13574443, 15758881, 13574443,
    13574443, 13574443, 13574443, 0, 0, 0, 0, 13574443, 13574443, 15758881, 15758881,
    15758881, 0, 0, 0, 13574443, 0, 13574443, 13574443, 15758881, 15758881, 15910701,
    15758881, 13574443, 13574443, 13574443, 0, 0, 13574443, 15758881, 15758881, 15910701,
    15910701, 15758881, 15758881, 13574443, 13574443, 13574443, 0, 13574443, 15758881,
    15758881, 15910701, 15910701, 15910701, 15758881, 15758881, 13574443, 13574443, 0,
    13574443, 15758881, 15758881, 15910701, 15910701, 15910701, 15758881, 15758881, 13574443,
    13574443, 0, 13574443, 13574443, 15758881, 15910701, 15910701, 15910701, 15758881,
    15758881, 13574443, 13574443, 0
};

static int* fire = (int*)fire_arr;

static uint32_t peanut_arr[121] = {
    0, 12910592, 12910592, 12910592, 12910592, 12910592, 12910592, 12910592, 12910592,
    12910592, 0, 0, 12910592, 12910592, 12910592, 12910592, 12910592, 12910592, 12910592,
    12910592, 12910592, 0, 0, 0, 16742144, 16742144, 16742144, 16742144, 16742144, 16742144,
    16742144, 0, 0, 0, 16742144, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215,
    16777215, 16742144, 0, 0, 16742144, 16777215, 16777215, 16777215, 16777215, 12408832,
    12408832, 16777215, 16742144, 0, 0, 16742144, 16777215, 16777215, 16777215, 16777215,
    12408832, 12408832, 16777215, 16742144, 0, 0, 16742144, 16777215, 16777215, 12408832,
    12408832, 16777215, 16777215, 16777215, 16742144, 0, 0, 16742144, 16777215, 16777215,
    12408832, 12408832, 16777215, 16777215, 16777215, 16742144, 0, 0, 16742144, 16777215,
    16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16742144, 0, 0, 0, 16742144,
    16742144, 16742144, 16742144, 16742144, 16742144, 16742144, 0, 0, 0, 0, 0, 16742144,
    16742144, 16742144, 16742144, 16742144, 0, 0, 0
};

static int* peanut = (int*)peanut_arr;

static uint32_t heart_arr[121] = {
    0, 0, 16777215, 16777215, 0, 0, 0, 16777215, 16777215, 16777215, 0, 0, 16777215, 
    16711680, 16711680, 16777215, 0, 16777215, 16711680, 9895936, 16777215, 0, 16777215, 
    16748688, 16711680, 16711680, 16056320, 16777215, 16056320, 16711680, 16711680, 13565952, 
    16777215, 16777215, 16728642, 0, 16711680, 16711680, 16711680, 16711680, 16711680, 
    16711680, 13565952, 16777215, 16777215, 16713736, 0, 16711680, 16711680, 16711680, 
    16711680, 16711680, 16711680, 14221312, 16777215, 16777215, 14045778, 16711680, 0, 
    16711680, 16711680, 16711680, 16711680, 13303808, 10092544, 16777215, 0, 16777215, 
    16711680, 16711680, 16711680, 16711680, 16711680, 13631488, 16777215, 16777215, 0, 
    0, 0, 16777215, 13893632, 16711680, 16711680, 16711680, 10092544, 16777215, 0, 0, 
    0, 0, 0, 16777215, 16711680, 16711680, 10223616, 16777215, 0, 0, 0, 0, 0, 0, 0, 16777215, 
    8847360, 16777215, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16777215, 0, 0, 0, 0, 0};

static int* heart = (int*)heart_arr;


static uint32_t spell_arr[121] = {
    0, 0, 0, 0, 15854080, 15854080, 15854080, 0, 0, 0, 0, 0, 0, 0, 15854080, 15854080, 
    15854080, 15854080, 15854080, 0, 0, 0, 0, 0, 0, 0, 4553113, 4553113, 4553113, 0, 
    0, 0, 0, 0, 0, 0, 0, 4553113, 4553113, 4553113, 0, 0, 0, 0, 0, 0, 0, 0, 4553113, 
    4553113, 4553113, 0, 0, 0, 0, 0, 0, 0, 0, 16720932, 16720932, 16720932, 0, 0, 0, 
    0, 0, 0, 0, 16720932, 16720932, 16720932, 16720932, 16720932, 0, 0, 0, 0, 0, 16720932, 
    16720932, 16720932, 16720932, 16720932, 16720932, 16720932, 0, 0, 0, 16720932, 16720932, 
    16720932, 16720932, 16720932, 16720932, 16720932, 16720932, 16720932, 0, 16720932, 
    16720932, 16720932, 16720932, 16720932, 16720932, 16720932, 16720932, 16720932, 16720932, 
    16720932, 16720932, 16720932, 16720932, 16720932, 16720932, 16720932, 16720932, 16720932, 
    16720932, 16720932, 16720932};

static int* spell = (int*)spell_arr;


static uint32_t wall_arr[121] = {
    16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 
    16777215, 16777215, 8076059, 8076059, 8076059, 8076059, 16777215, 8076059, 8076059, 
    8076059, 8076059, 16777215, 8076059, 8076059, 8076059, 8076059, 8076059, 16777215, 
    8076059, 8076059, 8076059, 8076059, 16777215, 8076059, 8076059, 8076059, 8076059, 
    8076059, 16777215, 8076059, 8076059, 8076059, 8076059, 16777215, 8076059, 8076059, 
    8076059, 8076059, 8076059, 16777215, 8076059, 8076059, 8076059, 8076059, 16777215, 
    8076059, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 
    16777215, 16777215, 16777215, 8076059, 16777215, 8076059, 8076059, 8076059, 8076059, 
    16777215, 8076059, 8076059, 8076059, 8076059, 8076059, 16777215, 8076059, 8076059, 
    8076059, 8076059, 16777215, 8076059, 8076059, 8076059, 8076059, 8076059, 16777215, 
    8076059, 8076059, 8076059, 8076059, 16777215, 8076059, 8076059, 8076059, 8076059, 
    8076059, 16777215, 8076059, 8076059, 8076059, 8076059, 16777215, 8076059, 8076059, 
    8076059, 8076059, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 
    16777215, 16777215, 16777215, 16777215};

static int* wall = (int*)wall_arr;


static uint32_t key_arr[121] = {
    0, 0, 0, 0, 0, 0, 0, 16766720, 16766720, 16766720, 16766720, 0, 0, 0, 0, 0, 0, 16766720, 
    16766720, 0, 0, 16766720, 0, 0, 0, 0, 0, 16766720, 16766720, 0, 0, 0, 16766720, 0, 
    0, 0, 0, 16766720, 16766720, 0, 0, 0, 0, 0, 0, 0, 0, 16766720, 16766720, 16766720, 
    16766720, 16766720, 0, 0, 0, 0, 0, 16766720, 16766720, 0, 0, 0, 16766720, 0, 0, 0, 
    0, 16766720, 16766720, 16766720, 16766720, 0, 0, 0, 0, 0, 0, 16766720, 16766720, 
    0, 16766720, 16766720, 0, 0, 0, 0, 0, 0, 16766720, 0, 0, 0, 16766720, 0, 0, 0, 0, 
    0, 0, 16766720, 16766720, 0, 16766720, 16766720, 0, 0, 0, 0, 0, 0, 0, 16766720, 16766720, 
    16766720, 0, 0, 0, 0, 0, 0, 0};

static int* key = (int*)key_arr;

static uint32_t treasure_arr[121] = {
    0, 6830876, 6830876, 6830876, 6830876, 13938442, 6830876, 6830876, 6830876, 6830876, 
    0, 6830876, 6830876, 6830876, 6830876, 13938442, 13938442, 13938442, 6830876, 6830876, 
    6830876, 6830876, 6830876, 6830876, 6830876, 13938442, 14462720, 14462720, 14462720, 
    13938442, 6830876, 6765340, 6830876, 0, 6830876, 6830876, 6830876, 6830876, 6830876, 
    6830876, 6830876, 6830876, 6830876, 0, 0, 0, 262657, 262657, 262657, 262657, 262657, 
    262657, 262657, 0, 0, 0, 6830876, 2675722, 2675722, 709826, 145257, 145257, 13896202, 
    16743424, 6830876, 0, 6830876, 6830876, 2675722, 16711928, 16711928, 709826, 145257, 
    13896202, 16743424, 6830876, 6830876, 6830876, 6830876, 6830876, 16711928, 16711928, 
    709826, 13896202, 13896202, 6830876, 6830876, 6830876, 0, 0, 6830876, 6830876, 6830876, 
    6830876, 6830876, 6830876, 6830876, 0, 0, 16500481, 16500481, 0, 6830876, 6830876, 
    6830876, 6830876, 6830876, 0, 16500481, 16500481, 16500481, 16500481, 0, 6830876, 
    6830876, 6830876, 6830876, 6830876, 0, 16500481, 16500481};

static int* treasure = (int*)treasure_arr;

static uint32_t hammer_arr[121] = {
    0, 0, 0, 0, 0, 0, 2992099, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2992099, 2992099, 2992099, 
    0, 0, 0, 0, 0, 0, 0, 2992099, 2992099, 2992099, 2992099, 2992099, 0, 0, 0, 0, 0, 
    0, 0, 2992099, 2992099, 2992099, 2992099, 2992099, 0, 0, 0, 0, 0, 0, 7887393, 2992099, 
    2992099, 2926563, 2992099, 2992099, 0, 0, 0, 0, 7887393, 7887393, 7887393, 2992099, 
    2992099, 16777215, 2992099, 0, 0, 0, 7887393, 7887393, 7887393, 0, 0, 2992099, 2992099, 
    16777215, 0, 0, 7887393, 7887393, 7887393, 0, 0, 0, 0, 0, 0, 0, 7887393, 7887393, 
    7887393, 0, 0, 0, 0, 0, 0, 0, 7887393, 7887393, 7887393, 0, 0, 0, 0, 0, 0, 0, 0, 
    7887393, 7887393, 0, 0, 0, 0, 0, 0, 0, 0, 0};

static int* hammer = (int*)hammer_arr;


void draw_player(int u, int v, int key)
{
    uLCD.BLIT(u, v, 11, 11, duck3);
}

#define YELLOW 0xFFFF00
#define BROWN  0xD2691E
#define DIRT   BROWN
#define BLUE   0x0000FF
#define PINK   0xFF00FF
#define LIME   0x00FF00
#define ORANGE 0xFFA500
#define WHITE  0xFFFFFF

void draw_img(int u, int v, const char* img)
{
    int colors[11*11];
    for (int i = 0; i < 11*11; i++) {
        if (img[i] == 'R') colors[i] = RED;
        else if (img[i] == 'Y') colors[i] = YELLOW;
        else if (img[i] == 'G') colors[i] = GREEN;
        else if (img[i] == 'D') colors[i] = DIRT;
        else if (img[i] == '5') colors[i] = LGREY;
        else if (img[i] == '3') colors[i] = DGREY;
        else colors[i] = BLACK;
    }
    uLCD.BLIT(u, v, 11, 11, colors);
    wait_us(250); // Recovery time!
}

void draw_nothing(int u, int v)
{
    // Fill a tile with blackness
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
}

void draw_wall(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, BROWN);
}

void draw_plant(int u, int v)
{
    uLCD.BLIT(u,v,11,11,tree);
}

void draw_stairs(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, portal1);
}
void draw_npc(int u, int v)
{
    uLCD.BLIT(u,v,11,11,npc);
}

void draw_boss(int u, int v)
{
    uLCD.BLIT(u,v,11,11,boss);
}
void draw_dead(int u, int v)
{
    uLCD.BLIT(u,v, 11,11, dead);
}
void draw_fire(int u, int v)
{
    uLCD.BLIT(u,v,11,11,fire);
}
void draw_water(int u, int v)
{
    uLCD.BLIT(u,v,11,11,water);
}
void draw_taco(int u, int v)
{
    uLCD.BLIT(u,v,11,11,peanut);
}
void draw_door(int u, int v)
{
     uLCD.BLIT(u, v, 11, 11, wall);

}
void draw_red(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, 0xFF0000);

}
void draw_blue(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, BLUE);
}
void draw_treasure(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, treasure);

}

void draw_hammer(int u, int v)
{
    uLCD.BLIT(u, v, 11, 11, hammer);

}

void draw_healthPotion(int u, int v)
{
     uLCD.BLIT(u, v, 11, 11, spell);
}

void draw_heart(int u, int v)
{
     uLCD.BLIT(u, v, 11, 11, heart);
}

void draw_key(int u, int v){
    uLCD.BLIT(u, v, 11, 11, key);
    }

void draw_upper_status(int currX, int currY, int health, int lives)
{
    // Draw bottom border of status bar
    uLCD.line(0, 9, 127, 9, GREEN);
    uLCD.locate(0,0);
    uLCD.printf("X:%02d|Y:%02d|H:%02d|L:%d", currX, currY, health, lives);
    // Add other status info drawing code here
}

void draw_lower_status(int item, int potion1, int potion2,
bool has_key, bool firstDraw)
{
    if(firstDraw){
    // Draw top border of status bar
    uLCD.line(0, 118, 127, 118, GREEN);
        }
    if(item) {
        draw_hammer(1, 118);
//        uLCD.line(12, 118, 12, 127, 0xFFFFFF);
    }
    
    if(potion1) {
        draw_healthPotion(13, 118);
//        uLCD.line(24, 118, 24, 127, 0xFFFFFF);
    }
    if(potion2) {
        draw_heart(25, 118);
    }
    if(has_key) {
        draw_key(37, 118);
        }
    


    // Add other status info drawing code here
}

void draw_border()
{
    uLCD.filled_rectangle(0,     9, 127,  14, WHITE); // Top
    uLCD.filled_rectangle(0,    13,   2, 114, WHITE); // Left
    uLCD.filled_rectangle(0,   114, 127, 117, WHITE); // Bottom
    uLCD.filled_rectangle(124,  14, 127, 117, WHITE); // Right
}


