/**
 * Institution: Georgia Institute of Technology - ECE Department - Senior Design II
 * Team: AH3
 * Created: 3/24/2015
 * Last Edit: 3/26/2015
 * By: Taylor Andrews, Luke Panayioto
**/

#ifndef _DX6I_CONTROLLER_H_
#define _DX6I_CONTROLLER_H_

#include "mbed.h"

class DX6iController {
private:
    DigitalOut _pwmPin;

    /**
     * The signal received by the quadcopter is an array of nine PWM signals (called a PPM signal), and is
     * exactly 22 ms long.  Each segment in the array has a specific purpose.  The first four correspond to
     * the throttle, roll, pitch, and yaw, respectively.
     *
     * The fifth and sixth correspond to the stability and enable modes.  The stability mode configures the
     * quadcopter's internal stabilization systems through a combination of onboard accelerometers and
     * gyroscopes.  The stability mode has two presets, what I just label as "full" and "partial", in
     * addition to an "off" setting (below it is initialized with full stability enabled, and it is highly
     * encouraged to keep it there).  The Enable mode simply allows the quadcopter to throttle, and only
     * has two settings "on" and "off".  Obviously, this must be configured for "on", unless it is utilized
     * in some fashion as to prevent some sort of catastrophic collision.
     * 
     */

    // Channels: [Remainder] [Throttle] [Roll] [Pitch] [Yaw] [Stability] [Enable] ([Extra_1] [Extra_2]

    // delay between signals in microseconds (µSec)
    int pulseInterval;     // 400 µSec
    int nChannels;   //channels must be at least 7
    
    // uptime of each signal in microseconds     low  / mid / high                                  // Corrections to PPM signal order
    int Throttle_Uptime;           //1   700 / 1100 / 1500                                    // Throttle
    int Roll_Uptime;              //2   700 / 1100 / 1500 (R/L)                              // Roll
    int Pitch_Uptime;             //3   770 / 1170 / 1550 (B/F)                              // Pitch
    int Yaw_Uptime;               //4   700 / 1090 / 1500 (R/L)                              // Yaw
    int Stabilize_Uptime;         //5  LLLL / MMMM / 1500 (3,2,1)                            
    int Enable_Uptime;            //6   700 / ---- / 1500 (Off/On) Note: Bind I Button      
    int Extra_Uptime;             //7  LLLL / 1100 / HHHH                                    // IDK
    int Extra2_Uptime;            //8  LLLL / 1100 / HHHH                                    // IDK
    int Remainder_Uptime;
    
    // Trim values
    int mThrottleTrim;
    int mRollTrim;
    int mPitchTrim;
    int mYawTrim;
    
    void updateRemainder();
    
public:
    DX6iController(PinName pwmPin);
    ~DX6iController();
    
    void generateSignal(int externalDelay);
    
    void updateThrottle(int newThrottle);
    void updatePitch(int newPitch);
    void updateRoll(int newRoll);
    void updateYaw(int newYaw);
    
    void updateThrottleTrim(int newThrottleTrim);
    void updatePitchTrim(int newPitchTrim);
    void updateRollTrim(int newRollTrim);
    void updateYawTrim(int newYawTrim);
};

#endif // _DX6I_CONTROLLER_H_